/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.osm.geom;

import java.awt.geom.Rectangle2D;

public class Rectangle {
    private final Rectangle2D rect;

    private Rectangle(double xmin, double ymin, double xmax, double ymax) {
        this.rect = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    Rectangle2D toRectangle2D() {
        return this.rect;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private double xmin;
        private double ymin;
        private double xmax;
        private double ymax;

        public Rectangle build() {
            return new Rectangle(this.xmin, this.ymin, this.xmax, this.ymax);
        }

        public Builder xmin(double xmin) {
            this.xmin = xmin;
            return this;
        }

        public Builder ymin(double ymin) {
            this.ymin = ymin;
            return this;
        }

        public Builder xmax(double xmax) {
            this.xmax = xmax;
            return this;
        }

        public Builder ymax(double ymax) {
            this.ymax = ymax;
            return this;
        }
    }
}

