/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.osm.geom;

import java.awt.geom.Point2D;

public class Vector2D {
    private final double x;
    private final double y;

    public Vector2D(Point2D point) {
        this(point.getX(), point.getY());
    }

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D prod(double factor) {
        return new Vector2D(this.x * factor, this.y * factor);
    }

    public Vector2D sum(Vector2D other) {
        return new Vector2D(this.x + other.x, this.y + other.y);
    }

    public Vector2D diff(Vector2D other) {
        return new Vector2D(this.x - other.x, this.y - other.y);
    }

    public double dot(Vector2D other) {
        return this.x * other.x + this.y * other.y;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Point2D toPoint() {
        return new Point2D.Double(this.x, this.y);
    }
}

