/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.osm.util;

import com.google.common.base.Optional;
import de.ixilon.osm.schema.OsmTag;

public final class OsmTagUtils {
    private OsmTagUtils() {
    }

    public static <E extends Enum<E>> Optional<E> getTag(Iterable<OsmTag> tags, String key, Class<E> clazz) {
        Optional<String> text = OsmTagUtils.getTag(tags, key);
        if (text.isPresent()) {
            try {
                return Optional.of(Enum.valueOf(clazz, ((String)text.get()).toUpperCase().replace(':', '_')));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Optional.absent();
    }

    public static Optional<String> getTag(Iterable<OsmTag> tags, String key) {
        for (OsmTag tag : tags) {
            if (!key.equals(tag.getK())) continue;
            return Optional.of((Object)tag.getV());
        }
        return Optional.absent();
    }

    public static boolean isTag(Iterable<OsmTag> tags, String key) {
        for (OsmTag tag : tags) {
            if (!key.equals(tag.getK())) continue;
            return true;
        }
        return false;
    }

    public static boolean isTag(Iterable<OsmTag> tags, String key, String value) {
        for (OsmTag tag : tags) {
            if (!key.equals(tag.getK()) || !value.equals(tag.getV())) continue;
            return true;
        }
        return false;
    }
}

