/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.osm.util;

import com.google.common.base.Predicate;
import de.ixilon.osm.schema.Osm;
import de.ixilon.osm.schema.OsmNode;
import de.ixilon.osm.schema.OsmRelation;
import de.ixilon.osm.schema.OsmRoot;
import de.ixilon.osm.schema.OsmWay;
import net.openstreetcraft.osm.util.Filter;

public final class OsmUtils {
    private static final Predicate<Object> IS_NODE = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input != null && OsmNode.class.isAssignableFrom(input.getClass()) && this.isVisible((OsmNode)input);
        }

        private boolean isVisible(OsmNode node) {
            Boolean visible = node.isVisible();
            return visible == null || visible != false;
        }
    };
    private static final Predicate<Object> IS_WAY = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input != null && OsmWay.class.isAssignableFrom(input.getClass()) && this.isVisible((OsmWay)input);
        }

        private boolean isVisible(OsmWay way) {
            Boolean visible = way.isVisible();
            return visible == null || visible != false;
        }
    };
    private static final Predicate<Object> IS_RELATION = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input != null && OsmRelation.class.isAssignableFrom(input.getClass()) && this.isVisible((OsmRelation)input);
        }

        private boolean isVisible(OsmRelation relation) {
            Boolean visible = relation.isVisible();
            return visible == null || visible != false;
        }
    };

    private OsmUtils() {
    }

    @Deprecated
    public static Iterable<OsmNode> getNodes(Osm osm) {
        return Filter.filter(osm.getNodesAndRelationsAndWaies(), IS_NODE);
    }

    public static Iterable<OsmNode> getNodes(OsmRoot osm) {
        return Filter.filter(osm.getNodeOrRelationOrWay(), IS_NODE);
    }

    @Deprecated
    public static Iterable<OsmWay> getWays(Osm osm) {
        return Filter.filter(osm.getNodesAndRelationsAndWaies(), IS_WAY);
    }

    public static Iterable<OsmWay> getWays(OsmRoot osm) {
        return Filter.filter(osm.getNodeOrRelationOrWay(), IS_WAY);
    }

    @Deprecated
    public static Iterable<OsmRelation> getRelations(Osm osm) {
        return Filter.filter(osm.getNodesAndRelationsAndWaies(), IS_RELATION);
    }

    public static Iterable<OsmRelation> getRelations(OsmRoot osm) {
        return Filter.filter(osm.getNodeOrRelationOrWay(), IS_RELATION);
    }
}

