/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.osm.util;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import de.ixilon.osm.schema.OsmNd;
import de.ixilon.osm.schema.OsmNode;
import de.ixilon.osm.schema.OsmTag;
import de.ixilon.osm.schema.OsmWay;
import java.util.NoSuchElementException;
import java.util.Random;
import net.openstreetcraft.osm.geom.OsmNodeList;
import net.openstreetcraft.osm.util.Filter;

public final class OsmWayUtils {
    private static final Predicate<Object> IS_NODEREF = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input != null && OsmNd.class.isAssignableFrom(input.getClass());
        }
    };
    private static final Predicate<Object> IS_TAG = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input != null && OsmTag.class.isAssignableFrom(input.getClass());
        }
    };

    private OsmWayUtils() {
    }

    public static boolean isClosed(OsmWay way) {
        ImmutableList refs = ImmutableList.copyOf(OsmWayUtils.getNodeRefs(way));
        if (refs.isEmpty()) {
            return false;
        }
        int last = refs.size() - 1;
        return ((OsmNd)refs.get(0)).getRef() == ((OsmNd)refs.get(last)).getRef();
    }

    public static Iterable<OsmNode> getNodes(OsmWay way, OsmNodeList nodes) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (OsmNd nodeRef : OsmWayUtils.getNodeRefs(way)) {
            Optional<OsmNode> node = nodes.findNode(nodeRef.getRef());
            if (!node.isPresent()) continue;
            result.add(node.get());
        }
        return result.build();
    }

    public static Iterable<OsmNd> getNodeRefs(OsmWay way) {
        return Filter.filter(way.getTagOrNd(), IS_NODEREF);
    }

    public static Iterable<OsmTag> getTags(OsmWay way) {
        return Filter.filter(way.getTagOrNd(), IS_TAG);
    }

    public static Random createRandom(OsmWay way) {
        long seed = 0L;
        try {
            seed = OsmWayUtils.getNodeRefs(way).iterator().next().getRef();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return new Random(seed);
    }
}

