/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.preanalyzed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xcontent.XContentParser;

public class PreanalyzedTokenStream
extends TokenStream {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final PayloadAttribute payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final FlagsAttribute flagsAtt = (FlagsAttribute)this.addAttribute(FlagsAttribute.class);
    private XContentParser parser;
    private ArrayList<Map<String, Object>> tokenList;
    private int tokenIndex;

    public PreanalyzedTokenStream(XContentParser parser) throws IOException {
        this.parser = parser;
        this.parsePreanalyzedTokens();
        this.reset();
    }

    private void parsePreanalyzedTokens() throws NumberFormatException, IOException {
        XContentParser.Token currentToken;
        this.tokenList = new ArrayList();
        if (this.parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new IllegalStateException("The parser is expected to point to the beginning of the array of preanalyzed tokens but the current token type was " + this.parser.currentToken());
        }
        HashMap<String, Object> tokenMap = null;
        while ((currentToken = this.parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (currentToken == XContentParser.Token.START_OBJECT) {
                tokenMap = new HashMap<String, Object>();
            }
            this.clearAttributes();
            boolean termFound = false;
            int start = -1;
            int end = -1;
            String currentFieldName = null;
            while ((currentToken = this.parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (currentToken == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = this.parser.currentName();
                    continue;
                }
                if (currentToken == XContentParser.Token.VALUE_STRING) {
                    if ("t".equals(currentFieldName)) {
                        char[] tokenBuffer = this.parser.textCharacters();
                        char[] bufferCopy = new char[this.parser.textLength()];
                        System.arraycopy(tokenBuffer, this.parser.textOffset(), bufferCopy, 0, bufferCopy.length);
                        tokenMap.put("t", bufferCopy);
                        termFound = true;
                        continue;
                    }
                    if ("p".equals(currentFieldName)) {
                        byte[] byteArray = this.parser.charBuffer().toString().getBytes("UTF-8");
                        BytesRef bytesRef = new BytesRef(byteArray);
                        tokenMap.put("p", bytesRef);
                        continue;
                    }
                    if ("f".equals(currentFieldName)) {
                        tokenMap.put("f", Integer.decode(this.parser.text()));
                        continue;
                    }
                    if (!"y".equals(currentFieldName)) continue;
                    tokenMap.put("y", this.parser.text());
                    continue;
                }
                if (currentToken != XContentParser.Token.VALUE_NUMBER) continue;
                if ("s".equals(currentFieldName)) {
                    start = this.parser.intValue();
                    continue;
                }
                if ("e".equals(currentFieldName)) {
                    end = this.parser.intValue();
                    continue;
                }
                if (!"i".equals(currentFieldName)) continue;
                tokenMap.put("i", this.parser.intValue());
            }
            tokenMap.put("s", start != -1 ? start : 0);
            tokenMap.put("e", end != -1 ? end : 0);
            if (!termFound) {
                throw new IllegalArgumentException("There is at least one token object in the pre-analyzed field value where no actual term string is specified.");
            }
            this.tokenList.add(tokenMap);
        }
    }

    public final boolean incrementToken() throws IOException {
        if (this.tokenIndex < this.tokenList.size()) {
            Map<String, Object> t = this.tokenList.get(this.tokenIndex);
            char[] termChars = (char[])t.get("t");
            BytesRef payload = (BytesRef)t.get("p");
            Integer flags = (Integer)t.get("f");
            String type = (String)t.get("y");
            Integer start = (Integer)t.get("s");
            Integer end = (Integer)t.get("e");
            Integer posInc = (Integer)t.get("i");
            try {
                this.clearAttributes();
                if (null != termChars) {
                    this.termAtt.copyBuffer(termChars, 0, termChars.length);
                }
                if (null != payload) {
                    this.payloadAtt.setPayload(payload);
                }
                if (null != flags) {
                    this.flagsAtt.setFlags(flags.intValue());
                }
                if (null != type) {
                    this.typeAtt.setType(type);
                }
                if (null != posInc) {
                    this.posIncrAtt.setPositionIncrement(posInc.intValue());
                }
                if (null != start && null != end && -1 != start && -1 != end) {
                    this.offsetAtt.setOffset(start.intValue(), end.intValue());
                    ++this.tokenIndex;
                    return true;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occurred at token term: " + new String(termChars) + ", start: " + start + ", end: " + end + ", positionIncrement: " + posInc, e);
            }
        }
        return false;
    }

    public void reset() throws IOException {
        this.tokenIndex = 0;
    }
}

