/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.gnp;

import GNormPluslib.GNormPlus;
import com.pengyifan.bioc.BioCCollection;
import com.pengyifan.bioc.io.BioCCollectionWriter;
import de.julielab.java.utilities.FileUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GNormPlusProcessing {
    private static final Logger log = LoggerFactory.getLogger(GNormPlusProcessing.class);

    public static synchronized void initializeGNormPlus(String setupFileResourcePath, String focusSpecies) throws IOException {
        if (!GNormPlus.initialized) {
            InputStream setupFileStream = FileUtilities.findResource((String)setupFileResourcePath);
            if (setupFileStream == null) {
                throw new IOException("Could not find resource as file or classpath resource " + setupFileResourcePath);
            }
            GNormPlus.loadConfiguration((InputStream)setupFileStream, (String)focusSpecies);
            GNormPlus.loadResources((String)focusSpecies, (double)System.currentTimeMillis());
        }
    }

    public static BioCCollection createEmptyJulieLabBioCCollection() {
        BioCCollection bioCCollection = new BioCCollection();
        bioCCollection.setDate(new Date().toString());
        bioCCollection.setEncoding("UTF-8");
        bioCCollection.setKey("BioC.key");
        bioCCollection.setSource("JULIE Lab GNormPlus");
        return bioCCollection;
    }

    public static Path processWithGNormPlus(BioCCollection bioCCollection, String outputDirectory) throws AnalysisEngineProcessException {
        String collectionId = "collection_including_" + bioCCollection.getDocument(0).getID();
        Path filePath = Path.of("jcore-gnp-tmp", collectionId + ".xml");
        Path outputFilePath = Path.of(outputDirectory.isBlank() ? "tmp" : outputDirectory, collectionId + "processed.xml");
        try {
            try {
                if (!Files.exists(filePath.getParent(), new LinkOption[0])) {
                    Files.createDirectory(filePath.getParent(), new FileAttribute[0]);
                }
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            if (!Files.exists(outputFilePath.getParent(), new LinkOption[0])) {
                Files.createDirectories(outputFilePath.getParent(), new FileAttribute[0]);
            }
            try (BioCCollectionWriter w = new BioCCollectionWriter(filePath);){
                w.writeCollection(bioCCollection);
            }
            GNormPlus.processFile((String)filePath.toString(), (String)filePath.getFileName().toString(), (String)outputFilePath.toString(), (double)System.currentTimeMillis(), (String)"Test");
            Files.delete(filePath);
        }
        catch (IOException | XMLStreamException e) {
            log.error("Could not process document {}", (Object)collectionId);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        return outputFilePath;
    }
}

