/*
 * Decompiled with CFR 0.152.
 */
package de.kevcodez.pubg.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import de.kevcodez.pubg.client.PlayerFilter;
import de.kevcodez.pubg.exception.ApiException;
import de.kevcodez.pubg.model.Region;
import de.kevcodez.pubg.model.match.MatchResponse;
import de.kevcodez.pubg.model.player.PlayerResponse;
import de.kevcodez.pubg.model.season.SeasonResponse;
import de.kevcodez.pubg.model.status.Status;
import de.kevcodez.pubg.model.telemetry.events.TelemetryEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0003J\u0016\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lde/kevcodez/pubg/client/ApiClient;", "", "apiKey", "", "httpClient", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "buildRequest", "Lokhttp3/Request;", "url", "Lokhttp3/HttpUrl;", "getMatch", "Lde/kevcodez/pubg/model/match/MatchResponse;", "region", "Lde/kevcodez/pubg/model/Region;", "id", "getPlayer", "Lde/kevcodez/pubg/model/player/PlayerResponse;", "season", "getPlayers", "playerFilter", "Lde/kevcodez/pubg/client/PlayerFilter;", "getSeasons", "Lde/kevcodez/pubg/model/season/SeasonResponse;", "getStatus", "Lde/kevcodez/pubg/model/status/Status;", "getTelemetryData", "", "Lde/kevcodez/pubg/model/telemetry/events/TelemetryEvent;", "URL", "Companion", "pubg-api-wrapper"})
public final class ApiClient {
    private final ObjectMapper objectMapper;
    private final String apiKey;
    private final OkHttpClient httpClient;
    private static final Logger LOG;
    private static final String API_SCHEME = "https";
    private static final String API_HOST = "api.playbattlegrounds.com";
    public static final Companion Companion;

    @NotNull
    public final PlayerResponse getPlayer(@NotNull Region region, @NotNull String id, @Nullable String season) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)region), (String)"region");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(API_SCHEME).host(API_HOST).addPathSegment("shards").addPathSegment(region.getIdentifier()).addPathSegment("players").addPathSegment(id);
        if (season != null) {
            urlBuilder = urlBuilder.addPathSegment("seasons").addPathSegment(season);
        }
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        Request request = this.buildRequest(httpUrl);
        Response response = this.httpClient.newCall(request).execute();
        if (response.code() != 200) {
            Response response2 = response;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            throw (Throwable)new ApiException(response2);
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        Object object = this.objectMapper.readValue(responseBody.string(), PlayerResponse.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(r\u2026ayerResponse::class.java)");
        return (PlayerResponse)object;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ PlayerResponse getPlayer$default(ApiClient apiClient, Region region, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return apiClient.getPlayer(region, string, string2);
    }

    @NotNull
    public final PlayerResponse getPlayers(@NotNull Region region, @NotNull PlayerFilter playerFilter) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)region), (String)"region");
        Intrinsics.checkParameterIsNotNull((Object)playerFilter, (String)"playerFilter");
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(API_SCHEME).host(API_HOST).addPathSegment("shards").addPathSegment(region.getIdentifier()).addPathSegment("players");
        Collection collection = playerFilter.getPlayerIds();
        if (!collection.isEmpty()) {
            urlBuilder = urlBuilder.addEncodedQueryParameter("filter[playerIds]", CollectionsKt.joinToString$default((Iterable)playerFilter.getPlayerIds(), null, null, null, (int)0, null, null, (int)63, null));
        }
        if (!(collection = (Collection)playerFilter.getPlayerNames()).isEmpty()) {
            urlBuilder = urlBuilder.addEncodedQueryParameter("filter[playerNames]", CollectionsKt.joinToString$default((Iterable)playerFilter.getPlayerNames(), null, null, null, (int)0, null, null, (int)63, null));
        }
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        Request request = this.buildRequest(httpUrl);
        Response response = this.httpClient.newCall(request).execute();
        if (response.code() != 200) {
            Response response2 = response;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            throw (Throwable)new ApiException(response2);
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        String bodyAsString = responseBody.string();
        Object object = this.objectMapper.readValue(bodyAsString, PlayerResponse.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(b\u2026ayerResponse::class.java)");
        return (PlayerResponse)object;
    }

    @NotNull
    public final MatchResponse getMatch(@NotNull Region region, @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)region), (String)"region");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(API_SCHEME).host(API_HOST).addPathSegment("shards").addPathSegment(region.getIdentifier()).addPathSegment("matches").addPathSegment(id);
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        Request request = this.buildRequest(httpUrl);
        Response response = this.httpClient.newCall(request).execute();
        if (response.code() != 200) {
            Response response2 = response;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            throw (Throwable)new ApiException(response2);
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        String bodyAsString = responseBody.string();
        Object object = this.objectMapper.readValue(bodyAsString, MatchResponse.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(b\u2026atchResponse::class.java)");
        return (MatchResponse)object;
    }

    @NotNull
    public final List<TelemetryEvent> getTelemetryData(@NotNull String URL) {
        HttpUrl httpUrl;
        Intrinsics.checkParameterIsNotNull((Object)URL, (String)"URL");
        HttpUrl httpUrl2 = HttpUrl.parse((String)URL);
        if (httpUrl2 == null) {
            Intrinsics.throwNpe();
        }
        HttpUrl httpUrl3 = httpUrl = httpUrl2;
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl3, (String)"httpUrl");
        Request request = this.buildRequest(httpUrl3);
        Response response = this.httpClient.newCall(request).execute();
        if (response.code() != 200) {
            Response response2 = response;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            throw (Throwable)new ApiException(response2);
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        Object object = this.objectMapper.readValue(responseBody.string(), (TypeReference)new TypeReference<List<? extends TelemetryEvent>>(){});
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(r\u2026st<TelemetryEvent>>() {})");
        return (List)object;
    }

    @NotNull
    public final SeasonResponse getSeasons(@NotNull Region region) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)region), (String)"region");
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(API_SCHEME).host(API_HOST).addPathSegment("shards").addPathSegment(region.getIdentifier()).addPathSegment("seasons");
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        Request request = this.buildRequest(httpUrl);
        Response response = this.httpClient.newCall(request).execute();
        if (response.code() != 200) {
            Response response2 = response;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            throw (Throwable)new ApiException(response2);
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        String bodyAsString = responseBody.string();
        Object object = this.objectMapper.readValue(bodyAsString, SeasonResponse.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(b\u2026asonResponse::class.java)");
        return (SeasonResponse)object;
    }

    @NotNull
    public final Status getStatus() {
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(API_SCHEME).host(API_HOST).addPathSegment("status");
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        Request request = this.buildRequest(httpUrl);
        Response response = this.httpClient.newCall(request).execute();
        if (response.code() != 200) {
            Response response2 = response;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            throw (Throwable)new ApiException(response2);
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        Object object = this.objectMapper.readValue(responseBody.string(), Status.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(r\u2026ng(), Status::class.java)");
        return (Status)object;
    }

    private final Request buildRequest(HttpUrl url) {
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.apiKey).addHeader("Accept", "application/vnd.api+json").build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Builder()\n      \u2026on\")\n            .build()");
        return request;
    }

    public ApiClient(@NotNull String apiKey, @NotNull OkHttpClient httpClient) {
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        Intrinsics.checkParameterIsNotNull((Object)httpClient, (String)"httpClient");
        this.apiKey = apiKey;
        this.httpClient = httpClient;
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule(0, 1, null)).registerModule((Module)new JavaTimeModule()).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"ObjectMapper()\n        .\u2026TY_STRING_AS_NULL_OBJECT)");
        this.objectMapper = objectMapper;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(ApiClient.class);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/kevcodez/pubg/client/ApiClient$Companion;", "", "()V", "API_HOST", "", "API_SCHEME", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "pubg-api-wrapper"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

