package org.jqassistant.contrib.plugin.csharp.json_to_neo4j.caches;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.FullQualifiedNameDescriptor;
import org.jqassistant.contrib.plugin.csharp.model.NamespaceDescriptor;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class NamespaceCache {

    private final Store store;
    private final HashMap<String, NamespaceDescriptor> cache;

    public NamespaceCache(Store store) {
        this.store = store;
        this.cache = new HashMap<>();
    }

    public NamespaceDescriptor findOrCreate(String key) {

        if (cache.containsKey(key)) {
            return cache.get(key);
        }

        NamespaceDescriptor descriptor = store.create(NamespaceDescriptor.class);
        descriptor.setFullQualifiedName(key);
        cache.put(key, descriptor);

        return descriptor;
    }

    public List<NamespaceDescriptor> getAllNamespaces() {
        return new LinkedList<>(cache.values());
    }

    public List<String> getAllNamespaceFQNs() {
        return getAllNamespaces()
                .stream()
                .map(FullQualifiedNameDescriptor::getFullQualifiedName)
                .collect(Collectors.toList());
    }
}
