/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.git.scanner;

import org.eclipse.jgit.diff.DiffEntry;

public class GitChange {
    private final String modificationKind;
    private final String relativePath;
    private final String changeType;
    private final String oldPath;
    private final String newPath;

    public GitChange(String changeType, String oldPath, String newPath) {
        this.modificationKind = changeType.substring(0, 1);
        this.relativePath = DiffEntry.ChangeType.DELETE.name().equalsIgnoreCase(changeType) ? oldPath : newPath;
        this.changeType = changeType;
        this.oldPath = oldPath;
        this.newPath = newPath;
    }

    public String getModificationKind() {
        return this.modificationKind;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getChangeType() {
        return this.changeType;
    }

    public String getOldPath() {
        return this.oldPath;
    }

    public String getNewPath() {
        return this.newPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitChange gitChange = (GitChange)o;
        if (this.modificationKind != null ? !this.modificationKind.equals(gitChange.modificationKind) : gitChange.modificationKind != null) {
            return false;
        }
        if (this.relativePath != null ? !this.relativePath.equals(gitChange.relativePath) : gitChange.relativePath != null) {
            return false;
        }
        if (this.changeType != null ? !this.changeType.equals(gitChange.changeType) : gitChange.changeType != null) {
            return false;
        }
        if (this.oldPath != null ? !this.oldPath.equals(gitChange.oldPath) : gitChange.oldPath != null) {
            return false;
        }
        return !(this.newPath != null ? !this.newPath.equals(gitChange.newPath) : gitChange.newPath != null);
    }

    public int hashCode() {
        int result = this.modificationKind != null ? this.modificationKind.hashCode() : 0;
        result = 31 * result + (this.relativePath != null ? this.relativePath.hashCode() : 0);
        result = 31 * result + (this.changeType != null ? this.changeType.hashCode() : 0);
        result = 31 * result + (this.oldPath != null ? this.oldPath.hashCode() : 0);
        result = 31 * result + (this.newPath != null ? this.newPath.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GitChange{modificationKind='" + this.modificationKind + '\'' + ", relativePath='" + this.relativePath + '\'' + ", changeType='" + this.changeType + '\'' + ", oldPath='" + this.oldPath + '\'' + ", newPath='" + this.newPath + '\'' + '}';
    }
}

