/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.javaparser.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.metamodel.NodeMetaModel;
import com.github.javaparser.metamodel.PropertyMetaModel;
import com.github.javaparser.utils.Utils;
import de.kontext_e.jqassistant.plugin.javaparser.scanner.MyGraphDatabaseService;
import de.kontext_e.jqassistant.plugin.javaparser.store.descriptor.JavaSourceDescriptor;
import de.kontext_e.jqassistant.plugin.javaparser.store.descriptor.JavaSourceFileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class JavaparserScannerPlugin
extends AbstractScannerPlugin<FileResource, JavaSourceDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaparserScannerPlugin.class);
    private static List<String> suffixes = Collections.singletonList("java");

    public boolean accepts(FileResource item, String path, Scope scope) {
        try {
            int beginIndex = path.lastIndexOf(".");
            if (beginIndex > 0) {
                String suffix = path.substring(beginIndex + 1).toLowerCase();
                boolean accepted = suffixes.contains(suffix);
                if (accepted) {
                    LOGGER.debug("Javaparser accepted path " + path);
                }
                return accepted;
            }
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error while checking path: " + e, (Throwable)e);
            return false;
        }
    }

    public JavaSourceDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        Store store = scanner.getContext().getStore();
        FileDescriptor fileDescriptor = (FileDescriptor)scanner.getContext().getCurrentDescriptor();
        JavaSourceFileDescriptor javaSourceFileDescriptor = (JavaSourceFileDescriptor)store.migrate((Descriptor)fileDescriptor, JavaSourceFileDescriptor.class, new Class[0]);
        this.importStream(store, item.createStream(), path);
        return javaSourceFileDescriptor;
    }

    private void importStream(Store store, InputStream stream, String path) {
        CompilationUnit cu = JavaParser.parse((InputStream)stream);
        this.output((com.github.javaparser.ast.Node)cu, path, new MyGraphDatabaseService(store), null, null);
    }

    private void output(com.github.javaparser.ast.Node node, String name, MyGraphDatabaseService graphDatabaseService, Node parent, String relName) {
        Utils.assertNotNull((Object)node);
        NodeMetaModel metaModel = node.getMetaModel();
        List allPropertyMetaModels = metaModel.getAllPropertyMetaModels();
        List attributes = allPropertyMetaModels.stream().filter(PropertyMetaModel::isAttribute).filter(PropertyMetaModel::isSingular).collect(Collectors.toList());
        List subNodes = allPropertyMetaModels.stream().filter(PropertyMetaModel::isNode).filter(PropertyMetaModel::isSingular).collect(Collectors.toList());
        List subLists = allPropertyMetaModels.stream().filter(PropertyMetaModel::isNodeList).collect(Collectors.toList());
        Node compilationUnit = graphDatabaseService.createNode(DynamicLabel.label((String)"JavaSource"), DynamicLabel.label((String)metaModel.getTypeName()));
        compilationUnit.setProperty("name", (Object)name);
        if (parent != null) {
            parent.createRelationshipTo(compilationUnit, () -> relName);
        }
        for (PropertyMetaModel a : attributes) {
            compilationUnit.setProperty(a.getName(), (Object)a.getValue(node).toString());
        }
        for (PropertyMetaModel sn : subNodes) {
            com.github.javaparser.ast.Node nd = (com.github.javaparser.ast.Node)sn.getValue(node);
            if (nd == null) continue;
            this.output(nd, sn.getName(), graphDatabaseService, compilationUnit, "SUBNODE");
        }
        for (PropertyMetaModel sl : subLists) {
            NodeList nl = (NodeList)sl.getValue(node);
            if (nl == null || !nl.isNonEmpty()) continue;
            String slName = sl.getName();
            slName = slName.endsWith("s") ? slName.substring(0, sl.getName().length() - 1) : slName;
            for (com.github.javaparser.ast.Node nd : nl) {
                this.output(nd, slName, graphDatabaseService, compilationUnit, "SUBLIST");
            }
        }
    }
}

