/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.logging;

import de.learnlib.logging.Category;
import de.learnlib.logging.LLConsoleFormatter;
import de.learnlib.logging.LearnLogRecord;
import de.learnlib.logging.PlottableLogRecord;
import de.learnlib.logging.StatisticLogRecord;
import de.learnlib.statistics.StatisticData;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LearnLogger
extends Logger {
    private LearnLogger(String name) {
        super(name, null);
    }

    public static LearnLogger getLogger(String name) {
        LogManager m = LogManager.getLogManager();
        Logger log = m.getLogger(name);
        if (log == null) {
            log = new LearnLogger(name);
            m.addLogger(log);
        }
        return (LearnLogger)log;
    }

    public static LearnLogger getLogger(Class<?> clazz) {
        return LearnLogger.getLogger(clazz.getName());
    }

    @Deprecated
    public static void defaultSetup() {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new LLConsoleFormatter());
        Logger logger = Logger.getLogger("");
        for (Handler h : logger.getHandlers()) {
            logger.removeHandler(h);
        }
        logger.addHandler(handler);
    }

    public static void setGlobalFilter(Filter f) {
        Logger logger = Logger.getLogger("");
        for (Handler h : logger.getHandlers()) {
            h.setFilter(f);
        }
    }

    public void logPhase(String phase) {
        LearnLogRecord rec = new LearnLogRecord(Level.INFO, phase, Category.PHASE);
        this.log(rec);
    }

    public void logQuery(String phase) {
        LearnLogRecord rec = new LearnLogRecord(Level.INFO, phase, Category.QUERY);
        this.log(rec);
    }

    public void logConfig(String config) {
        LearnLogRecord rec = new LearnLogRecord(Level.INFO, config, Category.CONFIG);
        this.log(rec);
    }

    public void logCounterexample(String ce) {
        LearnLogRecord rec = new LearnLogRecord(Level.INFO, ce, Category.COUNTEREXAMPLE);
        this.log(rec);
    }

    public void logEvent(String desc) {
        LearnLogRecord rec = new LearnLogRecord(Level.INFO, desc, Category.EVENT);
        this.log(rec);
    }

    public void logProfilingInfo(StatisticData profiling) {
        StatisticLogRecord rec = new StatisticLogRecord(Level.INFO, profiling, Category.PROFILING);
        this.log(rec);
    }

    public void logStatistic(StatisticData statistics) {
        StatisticLogRecord rec = new StatisticLogRecord(Level.INFO, statistics, Category.STATISTIC);
        this.log(rec);
    }

    public void logModel(Object o) {
        PlottableLogRecord rec = new PlottableLogRecord(Level.INFO, o, Category.MODEL);
        this.log(rec);
    }

    public void logDataStructure(Object o) {
        PlottableLogRecord rec = new PlottableLogRecord(Level.INFO, o, Category.DATASTRUCTURE);
        this.log(rec);
    }
}

