/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracles;

import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.api.QueryAnswerer;
import de.learnlib.oracles.DefaultQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public abstract class MQUtil {
    @Nullable
    public static <I, O> O output(MembershipOracle<I, O> oracle, Word<I> queryWord) {
        return MQUtil.query(oracle, queryWord).getOutput();
    }

    @Nullable
    public static <I, O> O output(MembershipOracle<I, O> oracle, Word<I> prefix, Word<I> suffix) {
        return MQUtil.query(oracle, prefix, suffix).getOutput();
    }

    @Nonnull
    public static <I, O> DefaultQuery<I, O> query(MembershipOracle<I, O> oracle, Word<I> prefix, Word<I> suffix) {
        DefaultQuery<I, Word<I>> qry = new DefaultQuery<I, Word<I>>(prefix, suffix);
        oracle.processQueries(Collections.singleton(qry));
        return qry;
    }

    @Nonnull
    public static <I, O> DefaultQuery<I, O> query(MembershipOracle<I, O> oracle, Word<I> queryWord) {
        return MQUtil.query(oracle, Word.epsilon(), queryWord);
    }

    public static <I, O> void answerQueries(QueryAnswerer<I, O> answerer, Collection<? extends Query<I, O>> queries) {
        for (Query<I, O> query : queries) {
            Word<I> prefix = query.getPrefix();
            Word<I> suffix = query.getSuffix();
            O answer = answerer.answerQuery(prefix, suffix);
            query.answer(answer);
        }
    }

    public static <I, O> boolean isCounterexample(DefaultQuery<I, O> query, SuffixOutput<I, O> hyp) {
        Object hypOut;
        O qryOut = query.getOutput();
        return !Objects.equals(qryOut, hypOut = hyp.computeSuffixOutput(query.getPrefix(), query.getSuffix()));
    }
}

