/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.settings;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class LearnLibSettings {
    private static final Logger LOG = Logger.getLogger(LearnLibSettings.class.getName());
    private static final LearnLibSettings INSTANCE = new LearnLibSettings();
    private final Properties properties = new Properties();

    public static LearnLibSettings getInstance() {
        return INSTANCE;
    }

    private LearnLibSettings() {
        try {
            Enumeration<URL> resourceUrls = this.getClass().getClassLoader().getResources("learnlib.properties");
            while (resourceUrls.hasMoreElements()) {
                URL url = resourceUrls.nextElement();
                try {
                    BufferedInputStream is = new BufferedInputStream(url.openStream());
                    Throwable throwable = null;
                    try {
                        this.properties.load(is);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (IOException ex) {
                    LOG.severe("Could not read property file " + url + ": " + ex.getMessage());
                }
            }
        }
        catch (IOException ex) {
            LOG.severe("Could not enumerate learnlib.properties files: " + ex.getMessage());
        }
        this.properties.putAll((Map<?, ?>)System.getProperties());
    }

    public String getProperty(String propName) {
        return this.properties.getProperty("learnlib." + propName);
    }

    public String getProperty(String propName, String defaultValue) {
        return this.properties.getProperty("learnlib." + propName, defaultValue);
    }

    public <E extends Enum<E>> E getEnumValue(String propName, Class<E> enumClazz) {
        String prop = this.getProperty(propName);
        if (prop == null) {
            return null;
        }
        return Enum.valueOf(enumClazz, prop.toUpperCase());
    }

    public <E extends Enum<E>> E getEnumValue(String propName, Class<E> enumClazz, E defaultValue) {
        E value = this.getEnumValue(propName, enumClazz);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean getBool(String propName, boolean defaultValue) {
        Boolean b = this.getBoolean(propName);
        if (b != null) {
            return b;
        }
        return defaultValue;
    }

    public Boolean getBoolean(String propName) {
        String prop = this.getProperty(propName);
        if (prop != null) {
            return Boolean.parseBoolean(prop);
        }
        return null;
    }

    public int getInt(String propName, int defaultValue) {
        Integer prop = this.getInteger(propName);
        if (prop != null) {
            return prop;
        }
        return defaultValue;
    }

    public Integer getInteger(String propName) {
        String prop = this.getProperty(propName);
        if (prop != null) {
            try {
                int val = Integer.parseInt(prop);
                return val;
            }
            catch (NumberFormatException ex) {
                LOG.warning("Could not parse LearnLib integer property '" + propName + "': " + ex.getMessage());
            }
        }
        return null;
    }
}

