/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.statistics;

import de.learnlib.statistics.StatisticData;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class HistogramDataSet
extends StatisticData {
    private SortedMap<Long, Integer> histogram = new TreeMap<Long, Integer>();
    private long size = 0L;
    private long sum = 0L;
    private double mean = 0.0;

    public HistogramDataSet(String name, String unit) {
        super(name, unit);
    }

    public void addDataPoint(Long value) {
        Integer i = (Integer)this.histogram.get(value);
        if (i == null) {
            i = 0;
        }
        this.histogram.put(value, i + 1);
        this.sum += value.longValue();
        ++this.size;
        this.mean += ((double)value.longValue() - this.mean) / (double)this.size;
    }

    @Nonnull
    public SortedMap<Long, Integer> getHistogram() {
        return this.histogram;
    }

    public double getMedian() {
        long idx = 0L;
        for (Map.Entry<Long, Integer> e : this.histogram.entrySet()) {
            int count = e.getValue();
            if ((idx += (long)count) < this.size / 2L) continue;
            return e.getValue().intValue();
        }
        return 0.0;
    }

    public double getMean() {
        return this.mean;
    }

    public long getSize() {
        return this.size;
    }

    public long getSum() {
        return this.sum;
    }

    @Override
    @Nonnull
    public String getSummary() {
        return this.getName() + " [" + this.getUnit() + "]: " + this.size + " (count), " + this.sum + " (sum), " + this.mean + " (mean), " + this.getMedian() + " (median)";
    }

    @Override
    @Nonnull
    public String getDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSummary()).append(System.getProperty("line.separator"));
        for (Map.Entry<Long, Integer> e : this.histogram.entrySet()) {
            sb.append("    ").append(e.getKey()).append(", ").append(e.getValue()).append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }
}

