/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.counterexamples;

import de.learnlib.api.AccessSequenceTransformer;
import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.counterexamples.LocalSuffixFinder;
import de.learnlib.oracles.MQUtil;
import java.util.Objects;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Word;

public abstract class LocalSuffixFinders {
    public static final LocalSuffixFinder<Object, Object> FIND_LINEAR = new LocalSuffixFinder<Object, Object>(){

        @Override
        public <RI, RO> int findSuffixIndex(Query<RI, RO> ceQuery, AccessSequenceTransformer<RI> asTransformer, SuffixOutput<RI, RO> hypOutput, MembershipOracle<RI, RO> oracle) {
            return LocalSuffixFinders.findLinear(ceQuery, asTransformer, hypOutput, oracle);
        }
    };
    public static final LocalSuffixFinder<Object, Object> FIND_LINEAR_REVERSE = new LocalSuffixFinder<Object, Object>(){

        @Override
        public <RI, RO> int findSuffixIndex(Query<RI, RO> ceQuery, AccessSequenceTransformer<RI> asTransformer, SuffixOutput<RI, RO> hypOutput, MembershipOracle<RI, RO> oracle) {
            return LocalSuffixFinders.findLinearReverse(ceQuery, asTransformer, hypOutput, oracle);
        }
    };
    public static final LocalSuffixFinder<Object, Object> RIVEST_SCHAPIRE = new LocalSuffixFinder<Object, Object>(){

        @Override
        public <RI, RO> int findSuffixIndex(Query<RI, RO> ceQuery, AccessSequenceTransformer<RI> asTransformer, SuffixOutput<RI, RO> hypOutput, MembershipOracle<RI, RO> oracle) {
            return LocalSuffixFinders.findRivestSchapire(ceQuery, asTransformer, hypOutput, oracle);
        }
    };

    public static <S, I, O> int findLinear(Query<I, O> ceQuery, AccessSequenceTransformer<I> asTransformer, SuffixOutput<I, O> hypOutput, MembershipOracle<I, O> oracle) {
        int min;
        Word queryWord = ceQuery.getInput();
        int queryLen = queryWord.length();
        Word prefix = ceQuery.getPrefix();
        int prefixLen = prefix.length();
        for (int i = min = asTransformer.isAccessSequence(prefix) ? prefixLen + 1 : prefixLen; i <= queryLen; ++i) {
            Object mqOut;
            Word nextSuffix;
            Word nextPrefix = queryWord.prefix(i);
            Word as = asTransformer.transformAccessSequence(nextPrefix);
            Object hypOut = hypOutput.computeSuffixOutput((Iterable)as, (Iterable)(nextSuffix = queryWord.subWord(i)));
            if (!Objects.equals(hypOut, mqOut = MQUtil.query(oracle, (Word)as, (Word)nextSuffix))) continue;
            return i;
        }
        return -1;
    }

    public static <I, O> int findLinearReverse(Query<I, O> ceQuery, AccessSequenceTransformer<I> asTransformer, SuffixOutput<I, O> hypOutput, MembershipOracle<I, O> oracle) {
        Word queryWord = ceQuery.getInput();
        int queryLen = queryWord.length();
        Word prefix = ceQuery.getPrefix();
        int prefixLen = prefix.length();
        int min = asTransformer.isAccessSequence(prefix) ? prefixLen : prefixLen - 1;
        for (int i = queryLen - 1; i >= min; --i) {
            Object mqOut;
            Word nextSuffix;
            Word nextPrefix = queryWord.prefix(i);
            Word as = asTransformer.transformAccessSequence(nextPrefix);
            Object hypOut = hypOutput.computeSuffixOutput((Iterable)as, (Iterable)(nextSuffix = queryWord.subWord(i)));
            if (Objects.equals(hypOut, mqOut = MQUtil.query(oracle, (Word)as, (Word)nextSuffix))) continue;
            return i + 1;
        }
        return -1;
    }

    public static <I, O> int findRivestSchapire(Query<I, O> ceQuery, AccessSequenceTransformer<I> asTransformer, SuffixOutput<I, O> hypOutput, MembershipOracle<I, O> oracle) {
        Word queryWord = ceQuery.getInput();
        int queryLen = queryWord.length();
        Word prefix = ceQuery.getPrefix();
        int prefixLen = prefix.length();
        int low = asTransformer.isAccessSequence(prefix) ? prefixLen : prefixLen - 1;
        int high = queryLen;
        while (high - low > 1) {
            Object ceOut;
            Word nextSuffix;
            int mid = low + (high - low + 1) / 2;
            Word nextPrefix = queryWord.prefix(mid);
            Word as = asTransformer.transformAccessSequence(nextPrefix);
            Object hypOut = hypOutput.computeSuffixOutput((Iterable)as, (Iterable)(nextSuffix = queryWord.subWord(mid)));
            if (!Objects.equals(hypOut, ceOut = MQUtil.query(oracle, (Word)as, (Word)nextSuffix))) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return low + 1;
    }

    private LocalSuffixFinders() {
    }
}

