/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.maven.plugin.node;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;

class Extractor {
    Extractor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void uncompress(Log log, InputStream in, File target) throws IOException, CompressorException, ArchiveException {
        CompressorStreamFactory csf = new CompressorStreamFactory();
        csf.setDecompressConcatenated(true);
        CompressorInputStream cin = csf.createCompressorInputStream((InputStream)new BufferedInputStream(in));
        File temp = File.createTempFile("smaller-npm", ".tar");
        try {
            FileUtils.copyInputStreamToFile((InputStream)cin, (File)temp);
            FileInputStream fin = new FileInputStream(temp);
            try {
                ArchiveInputStream ain = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(fin));
                ArchiveEntry entry = ain.getNextEntry();
                while (entry != null) {
                    Extractor.extractEntry(log, target, ain, entry);
                    entry = ain.getNextEntry();
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)fin);
            }
        }
        finally {
            temp.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractEntry(Log log, File target, ArchiveInputStream ain, ArchiveEntry entry) throws IOException {
        String name = entry.getName();
        if (name.startsWith("package")) {
            name = name.substring("package/".length());
        }
        log.debug((CharSequence)("... extracting " + name));
        File file = new File(target, name);
        if (!entry.isDirectory()) {
            file.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(file);
            try {
                byte[] buf = new byte[4096];
                long len = entry.getSize();
                int read = ain.read(buf, 0, Math.min(4096, (int)len));
                while (len > 0L) {
                    out.write(buf, 0, read);
                    if ((len -= (long)read) <= 0L) continue;
                    read = ain.read(buf, 0, Math.min(4096, (int)len));
                }
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
    }
}

