/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.maven.plugin.node;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ParsedVersion
implements Comparable<ParsedVersion> {
    private static final String NUM = "0|[1-9][0-9]*";
    private static final String NONNUM = "[0-9]*[-a-zA-Z][-a-zA-Z0-9]*";
    private static final String MAIN = "(0|[1-9][0-9]*)(?:\\.(0|[1-9][0-9]*))?(?:\\.(0|[1-9][0-9]*))?";
    private static final String PREREL = "(?:-((?:0|[1-9][0-9]*|[0-9]*[-a-zA-Z][-a-zA-Z0-9]*)(?:\\.(?:0|[1-9][0-9]*|[0-9]*[-a-zA-Z][-a-zA-Z0-9]*))*))";
    private static final String BUILD = "(?:\\+([-a-zA-Z0-9]+(?:\\.[-a-zA-Z0-9]+)*))";
    private static final Pattern FULL = Pattern.compile("v?(0|[1-9][0-9]*)(?:\\.(0|[1-9][0-9]*))?(?:\\.(0|[1-9][0-9]*))?(?:-((?:0|[1-9][0-9]*|[0-9]*[-a-zA-Z][-a-zA-Z0-9]*)(?:\\.(?:0|[1-9][0-9]*|[0-9]*[-a-zA-Z][-a-zA-Z0-9]*))*))?(?:\\+([-a-zA-Z0-9]+(?:\\.[-a-zA-Z0-9]+)*))?");
    private int major = 0;
    private int minor = 0;
    private int patch = 0;
    private String pre = null;
    private String build = null;

    ParsedVersion() {
    }

    static ParsedVersion parse(String str) {
        Matcher matcher = FULL.matcher(str);
        if (matcher.matches()) {
            ParsedVersion v = new ParsedVersion();
            if (matcher.groupCount() > 0) {
                v.major = Integer.parseInt(matcher.group(1));
            }
            if (matcher.groupCount() > 1 && matcher.group(2) != null) {
                v.minor = Integer.parseInt(matcher.group(2));
            }
            if (matcher.groupCount() > 2 && matcher.group(3) != null) {
                v.patch = Integer.parseInt(matcher.group(3));
            }
            if (matcher.groupCount() > 3) {
                v.pre = matcher.group(4);
            }
            if (matcher.groupCount() > 4) {
                v.build = matcher.group(5);
            }
            return v;
        }
        return null;
    }

    @Override
    public int compareTo(ParsedVersion o) {
        if (this.major == o.major) {
            if (this.minor == o.minor) {
                if (this.patch == o.patch) {
                    return 0;
                }
                return this.patch - o.patch;
            }
            return this.minor - o.minor;
        }
        return this.major - o.major;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (this.pre != null ? "-" + this.pre : "") + (this.build != null ? "+" + this.build : "");
    }
}

