/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.maven.plugin.node;

import de.matrixweb.smaller.maven.plugin.node.ParsedVersion;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Range {
    private static final String OPS = "~|<|<=|=|>=|>";
    private static final Pattern OP_MATCH = Pattern.compile("^(~|<|<=|=|>=|>)?\\s?(.*)$");
    private final Map<ParsedVersion, Op> opMap = new TreeMap<ParsedVersion, Op>();

    Range(String str) {
        String[] splits;
        str = str.replaceAll("(~|<|<=|=|>=|>)\\s+", "$1");
        for (String split : splits = str.split(" ")) {
            Matcher matcher = OP_MATCH.matcher(split);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(str);
            }
            String verStr = matcher.group(2);
            String op = matcher.group(1);
            if ("~".equals(op) && !verStr.contains("x") && !verStr.contains("X")) {
                this.opMap.putAll(new Range((String)this.createTildeVersion((String)verStr)).opMap);
                continue;
            }
            if (verStr.contains("x") || verStr.contains("X")) {
                this.opMap.putAll(new Range((String)this.createXVersion((String)verStr)).opMap);
                continue;
            }
            this.opMap.put(ParsedVersion.parse(verStr), Op.lookup(op));
        }
    }

    private String createTildeVersion(String str) {
        int i;
        StringBuilder sb = new StringBuilder();
        String[] m = str.split("[-\\+\\.]", 4);
        int[] n = new int[Math.min(3, m.length)];
        for (i = 0; i < n.length; ++i) {
            n[i] = m[i].equalsIgnoreCase("x") ? 0 : Integer.parseInt(m[i]);
        }
        sb.append(">=").append(n[0]);
        for (i = 1; i < n.length; ++i) {
            sb.append(".").append(n[i]);
        }
        if (n.length == 3 && n.length - 2 >= 0) {
            int n2 = n.length - 2;
            n[n2] = n[n2] + 1;
            n[n.length - 1] = 0;
        } else {
            int n3 = n.length - 1;
            n[n3] = n[n3] + 1;
        }
        sb.append(" <").append(n[0]);
        for (i = 1; i < n.length; ++i) {
            sb.append(".").append(n[i]);
        }
        return sb.toString();
    }

    private String createXVersion(String str) {
        int i;
        StringBuilder sb = new StringBuilder();
        String[] m = str.split("[-\\+\\.]", 4);
        int[] n = new int[Math.min(3, m.length)];
        for (i = 0; i < n.length; ++i) {
            n[i] = m[i].equalsIgnoreCase("x") ? 0 : Integer.parseInt(m[i]);
        }
        sb.append(">=").append(n[0]);
        for (i = 1; i < n.length; ++i) {
            sb.append(".").append(n[i]);
        }
        boolean incOnce = false;
        sb.append(" <");
        if (m.length > 1 && m[1].equalsIgnoreCase("x")) {
            sb.append(n[0] + 1);
            incOnce = true;
        } else {
            sb.append(n[0]);
        }
        for (int i2 = 1; i2 < n.length; ++i2) {
            if (!incOnce && m.length > i2 + 1 && m[i2 + 1].equalsIgnoreCase("x")) {
                sb.append(".").append(n[i2] + 1);
                continue;
            }
            sb.append(".").append(n[i2]);
        }
        return sb.toString();
    }

    boolean satisfies(ParsedVersion version) {
        boolean satisfies = true;
        for (Map.Entry<ParsedVersion, Op> entry : this.opMap.entrySet()) {
            satisfies &= entry.getValue().compare(version, entry.getKey());
        }
        return satisfies;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ParsedVersion, Op> entry : this.opMap.entrySet()) {
            sb.append(entry.getValue().op).append(entry.getKey()).append(' ');
        }
        return sb.toString().trim();
    }

    private static enum Op {
        LT("<"),
        LE("<="),
        EQ("="),
        GE(">="),
        GT(">");

        private final String op;

        private Op(String op) {
            this.op = op;
        }

        static Op lookup(String str) {
            if (str == null) {
                return EQ;
            }
            for (Op op : Op.values()) {
                if (!op.op.equals(str)) continue;
                return op;
            }
            throw new IllegalArgumentException(str);
        }

        boolean compare(ParsedVersion v1, ParsedVersion v2) {
            switch (this) {
                case LT: {
                    return v1.compareTo(v2) < 0;
                }
                case LE: {
                    return v1.compareTo(v2) <= 0;
                }
                case EQ: {
                    return v1.compareTo(v2) == 0;
                }
                case GE: {
                    return v1.compareTo(v2) >= 0;
                }
                case GT: {
                    return v1.compareTo(v2) > 0;
                }
            }
            return false;
        }
    }
}

