/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.maven.plugin.node;

import de.matrixweb.smaller.maven.plugin.node.Descriptor;
import de.matrixweb.smaller.maven.plugin.node.Extractor;
import de.matrixweb.smaller.maven.plugin.node.NpmCache;
import de.matrixweb.smaller.maven.plugin.node.ParsedVersion;
import de.matrixweb.smaller.maven.plugin.node.Range;
import de.matrixweb.smaller.maven.plugin.node.SemanticVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.stringtemplate.v4.ST;

@Mojo(name="smaller-node-builder", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class SmallerNodeBuilderMojo
extends AbstractMojo {
    private final ObjectMapper om = new ObjectMapper();
    @Parameter(required=true, readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, readonly=true, defaultValue="${basedir}")
    private File basedir;
    @Parameter(required=true)
    private String type;
    @Parameter(required=true)
    private String name;
    @Parameter(required=true)
    private List<String> packages;
    @Parameter(defaultValue="${basedir}/target/generated-resources/npm-modules")
    private File target;
    private File tempInstall;
    @Parameter(required=true)
    private String script;
    @Parameter(defaultValue="false")
    private boolean forceUpdate;
    private NpmCache cache;

    public final List<String> getPackages() {
        if (this.packages == null) {
            this.packages = new ArrayList<String>();
        }
        return this.packages;
    }

    public final void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public final void addPackage(String str) {
        this.getPackages().add(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.cache = new NpmCache(this.basedir);
        try {
            this.tempInstall = File.createTempFile("smaller-node-builder-temp", ".dir");
            this.tempInstall.delete();
            this.tempInstall.mkdirs();
            try {
                for (String pkgSpec : this.packages) {
                    this.getLog().info((CharSequence)("Installing " + pkgSpec));
                    Package pkg = new Package(pkgSpec);
                    pkg.install(this.tempInstall, this.tempInstall);
                    FileUtils.copyDirectory((File)this.tempInstall, (File)new File(this.getPackageTarget(), "node_modules"));
                }
            }
            finally {
                FileUtils.deleteDirectory((File)this.tempInstall);
            }
            FileUtils.write((File)new File(this.getPackageTarget(), "index.js"), (CharSequence)new ST(IOUtils.toString((URL)((Object)((Object)this)).getClass().getResource("/index.js.tmpl"))).add("script", (Object)this.script).render());
            String[] nameParts = this.name.split("-", 2);
            String lowername = nameParts[0].toLowerCase();
            String uppername = nameParts[0].substring(0, 1).toUpperCase() + nameParts[0].substring(1).toLowerCase();
            String nameVersion = this.name;
            String uppertype = this.type.toUpperCase();
            File classbase = new File(this.basedir, "target/generated-sources/npm-processor");
            File classtarget = new File(classbase, "de/matrixweb/smaller/" + lowername);
            classbase.mkdirs();
            FileUtils.write((File)new File(classtarget, uppername + "Processor.java"), (CharSequence)new ST(IOUtils.toString((URL)((Object)((Object)this)).getClass().getResource("/Processor.java.tmpl"))).add("lowername", (Object)lowername).add("uppername", (Object)uppername).add("name", (Object)nameParts[0]).add("nameVersion", (Object)nameVersion).add("uppertype", (Object)uppertype).render());
            this.project.addCompileSourceRoot(classbase.getPath());
            Resource resource = new Resource();
            resource.setDirectory(this.target.getAbsolutePath());
            this.project.addResource(resource);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to connect to npm registry", (Exception)e);
        }
    }

    private File getPackageTarget() {
        return new File(this.target, this.name);
    }

    class Package {
        private String name;
        private String version;
        private Descriptor descriptor;

        Package(String input) {
            int idx = input.indexOf(64);
            if (idx > -1) {
                this.name = input.substring(0, idx);
                this.version = input.substring(idx + 1);
            } else {
                this.name = input;
                this.version = "";
            }
        }

        public void setVersion(String version) {
            this.version = version;
        }

        Descriptor getDescriptor() throws IOException {
            if (this.descriptor == null) {
                String url = "http://registry.npmjs.org/" + this.name;
                InputStream stream = SmallerNodeBuilderMojo.this.cache.get(url);
                if (stream == null) {
                    SmallerNodeBuilderMojo.this.getLog().debug((CharSequence)("Requesting " + url));
                    Response response = Request.Get((String)url).execute();
                    SmallerNodeBuilderMojo.this.cache.put(url, response.returnContent().asStream());
                    stream = SmallerNodeBuilderMojo.this.cache.get(url);
                }
                this.descriptor = (Descriptor)SmallerNodeBuilderMojo.this.om.readValue(stream, Descriptor.class);
            }
            return this.descriptor;
        }

        InputStream downloadDist(Descriptor.Version ver) throws IOException {
            String url = ver.getDist().getTarball();
            InputStream in = SmallerNodeBuilderMojo.this.cache.get(url);
            if (in == null) {
                SmallerNodeBuilderMojo.this.getLog().info((CharSequence)("Downloading " + url));
                Response response = Request.Get((String)url).execute();
                SmallerNodeBuilderMojo.this.cache.put(url, response.returnContent().asStream());
                in = SmallerNodeBuilderMojo.this.cache.get(url);
            }
            return in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void install(File root, File installDir) throws IOException {
            String selectedVersion = this.version;
            if ("".equals(selectedVersion)) {
                selectedVersion = this.getDescriptor().getDistTags().getLatest();
            }
            Descriptor.Version ver = this.getDescriptor().getVersions().get(selectedVersion);
            File pkgDir = new File(installDir, this.name);
            try {
                InputStream in = this.downloadDist(ver);
                try {
                    Extractor.uncompress(SmallerNodeBuilderMojo.this.getLog(), in, pkgDir);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            catch (CompressorException e) {
                throw new IOException("Failed to decompress " + this.name + '@' + selectedVersion, e);
            }
            catch (ArchiveException e) {
                throw new IOException("Failed to decompress " + this.name + '@' + selectedVersion, e);
            }
            for (Map.Entry<String, String> dependency : ver.getDependencies().entrySet()) {
                String pkgName = dependency.getKey();
                String requiredVersion = dependency.getValue();
                SmallerNodeBuilderMojo.this.getLog().debug((CharSequence)("Looking for " + pkgName + '@' + requiredVersion + " in parent folders of " + pkgDir));
                String foundVersion = this.findInstalledVersion(root, pkgDir, pkgName);
                if (foundVersion != null && new Range(requiredVersion).satisfies(ParsedVersion.parse(foundVersion))) continue;
                Package depPkg = new Package(pkgName);
                depPkg.setVersion(SemanticVersion.getBestMatch(depPkg.getDescriptor().getVersions().keySet(), requiredVersion));
                depPkg.install(root, new File(pkgDir, "node_modules"));
            }
        }

        private String findInstalledVersion(File root, File dir, String pkgName) throws IOException {
            String version = null;
            File nodeModulesDir = new File(dir, "node_modules");
            File pkgDir = new File(nodeModulesDir, pkgName);
            if (pkgDir.exists()) {
                SmallerNodeBuilderMojo.this.getLog().debug((CharSequence)("  searching " + pkgDir + "..."));
                Map map = (Map)SmallerNodeBuilderMojo.this.om.readValue(new File(pkgDir, "package.json"), (TypeReference)new TypeReference<Map<String, Object>>(){});
                version = (String)map.get("version");
                SmallerNodeBuilderMojo.this.getLog().debug((CharSequence)("  found version " + version));
            } else if (!dir.getParentFile().equals(root)) {
                version = this.findInstalledVersion(root, dir.getParentFile(), pkgName);
            }
            return version;
        }
    }
}

