/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.daten.ListeFilme;
import de.mediathekview.mlib.tool.Hash;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MVHttpClient;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import mServer.tool.MserverDaten;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class AddToFilmlist {
    private static final int MIN_SIZE_ADD_OLD = 5;
    private static final int NUMBER_OF_THREADS = 32;
    private final ListeFilme vonListe;
    private final ListeFilme listeEinsortieren;
    private final ArrayList<ImportOldFilmlistThread> threadList = new ArrayList();
    private AtomicInteger threadCounter = new AtomicInteger(0);

    public AddToFilmlist(ListeFilme vonListe, ListeFilme listeEinsortieren) {
        this.vonListe = vonListe;
        this.listeEinsortieren = listeEinsortieren;
    }

    public synchronized void addLiveStream() {
        if (this.listeEinsortieren.size() <= 0) {
            return;
        }
        this.vonListe.removeIf(f -> f.arr[2].equals("Livestream"));
        this.listeEinsortieren.forEach(this.vonListe::add);
    }

    private void performTitleSearch(HashSet<Hash> hash, int size) {
        this.vonListe.parallelStream().forEach(f -> {
            HashSet hashSet = hash;
            synchronized (hashSet) {
                hash.add(f.getHashValueIndexAddOld());
            }
        });
        this.listeEinsortieren.removeIf(f -> hash.contains(f.getHashValueIndexAddOld()));
        hash.clear();
        Log.sysLog("===== Liste einsortieren Title =====");
        Log.sysLog("Liste einsortieren, Anzahl: " + size);
        Log.sysLog("Liste einsortieren, entfernt: " + (size - this.listeEinsortieren.size()));
        Log.sysLog("Liste einsortieren, noch einsortieren: " + this.listeEinsortieren.size());
        Log.sysLog("");
    }

    private void performUrlSearch(HashSet<Hash> hash, int size) {
        this.vonListe.parallelStream().forEach(f -> {
            HashSet hashSet = hash;
            synchronized (hashSet) {
                hash.add(f.getHashValueUrl());
            }
        });
        this.listeEinsortieren.removeIf(f -> hash.contains(f.getHashValueUrl()));
        hash.clear();
        Log.sysLog("===== Liste einsortieren URL =====");
        Log.sysLog("Liste einsortieren, Anzahl: " + size);
        Log.sysLog("Liste einsortieren, entfernt: " + (size - this.listeEinsortieren.size()));
        Log.sysLog("Liste einsortieren, noch einsortieren: " + this.listeEinsortieren.size());
        Log.sysLog("");
    }

    private void performInitialCleanup() {
        this.listeEinsortieren.removeIf(f -> !f.arr[14].toLowerCase().startsWith("http"));
        this.listeEinsortieren.removeIf(f -> {
            String groesse = f.arr[9];
            if (groesse.isEmpty()) {
                return false;
            }
            return Long.parseLong(groesse) < 5L;
        });
    }

    private void startThreads() {
        OkHttpClient client = MVHttpClient.getInstance().getReducedTimeOutClient();
        List<DatenFilm> syncList = Collections.synchronizedList(this.listeEinsortieren);
        for (int i = 0; i < 32; ++i) {
            ImportOldFilmlistThread t = new ImportOldFilmlistThread(syncList, client);
            t.setName("ImportOldFilmlistThread Thread-" + i);
            this.threadList.add(t);
            t.start();
        }
    }

    private void stopThreads() {
        if (Config.getStop()) {
            for (ImportOldFilmlistThread t : this.threadList) {
                t.interrupt();
            }
            for (ImportOldFilmlistThread t : this.threadList) {
                try {
                    t.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public int addOldList() {
        this.threadCounter = new AtomicInteger(0);
        HashSet<Hash> hash = new HashSet<Hash>(this.vonListe.size() + 1);
        this.performInitialCleanup();
        int size = this.listeEinsortieren.size();
        this.performTitleSearch(hash, size);
        size = this.listeEinsortieren.size();
        this.performUrlSearch(hash, size);
        size = this.listeEinsortieren.size();
        long oldSize = size;
        this.startThreads();
        int count = 0;
        while (!Config.getStop() && this.threadCounter.get() > 0) {
            try {
                if (++count % 5 == 0) {
                    long curSize = this.listeEinsortieren.size();
                    System.out.println("Liste: " + curSize);
                    System.out.println("Entfernte Eintr\u00e4ge: " + (oldSize - curSize));
                    oldSize = curSize;
                }
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (Exception ex) {
                Log.errorLog(978451205, ex, "Fehler beim Import Old");
            }
        }
        this.stopThreads();
        int treffer = this.retrieveThreadResults();
        Log.sysLog("===== Liste einsortieren: Noch online =====");
        Log.sysLog("Liste einsortieren, Anzahl: " + size);
        Log.sysLog("Liste einsortieren, entfernt: " + (size - treffer));
        Log.sysLog("");
        Log.sysLog("In Liste einsortiert: " + treffer);
        Log.sysLog("");
        return treffer;
    }

    private int retrieveThreadResults() {
        int treffer = 0;
        for (ImportOldFilmlistThread t : this.threadList) {
            ArrayList<DatenFilm> localList = t.getLocalAddList();
            if (MserverDaten.debug) {
                Log.sysLog("Thread " + t.getName() + " list size: " + localList.size());
            }
            this.vonListe.addAll(localList);
            localList.clear();
            treffer += t.getTreffer();
        }
        return treffer;
    }

    private class ImportOldFilmlistThread
    extends Thread {
        private final List<DatenFilm> listeOld;
        private final ArrayList<DatenFilm> localAddList;
        private int treffer;
        private OkHttpClient client;

        public ImportOldFilmlistThread(List<DatenFilm> listeOld, OkHttpClient client) {
            this.localAddList = new ArrayList(AddToFilmlist.this.vonListe.size() / 32 + 500);
            this.treffer = 0;
            this.client = null;
            this.listeOld = listeOld;
            AddToFilmlist.this.threadCounter.incrementAndGet();
            this.client = client;
        }

        public int getTreffer() {
            return this.treffer;
        }

        public ArrayList<DatenFilm> getLocalAddList() {
            return this.localAddList;
        }

        private void addOld(DatenFilm film) {
            ++this.treffer;
            film.init();
            this.localAddList.add(film);
        }

        private synchronized DatenFilm popOld(List<DatenFilm> listeOld) {
            if (!listeOld.isEmpty()) {
                return listeOld.remove(0);
            }
            return null;
        }

        @Override
        public void run() {
            DatenFilm film;
            while (!this.isInterrupted() && (film = this.popOld(this.listeOld)) != null) {
                Throwable throwable;
                Response response2;
                Request request;
                String url = film.arr[14];
                if (film.arr[9].isEmpty()) {
                    request = new Request.Builder().url(url).head().build();
                    try {
                        response2 = this.client.newCall(request).execute();
                        throwable = null;
                        try {
                            ResponseBody body = response2.body();
                            Throwable throwable2 = null;
                            try {
                                if (!response2.isSuccessful()) continue;
                                long respLength = body.contentLength();
                                if (respLength < 1000000L) {
                                    respLength = -1L;
                                } else if (respLength > 1000000L) {
                                    respLength /= 1000000L;
                                }
                                if (respLength <= 5L) continue;
                                this.addOld(film);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (body == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        body.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                body.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (response2 == null) continue;
                            if (throwable != null) {
                                try {
                                    response2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            response2.close();
                        }
                    }
                    catch (SocketTimeoutException response2) {
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                if (Long.parseLong(film.arr[9]) <= 5L) continue;
                request = new Request.Builder().url(url).head().build();
                try {
                    response2 = this.client.newCall(request).execute();
                    throwable = null;
                    try {
                        if (!response2.isSuccessful()) continue;
                        this.addOld(film);
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (response2 == null) continue;
                        if (throwable != null) {
                            try {
                                response2.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                            continue;
                        }
                        response2.close();
                    }
                }
                catch (SocketTimeoutException response3) {
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            AddToFilmlist.this.threadCounter.decrementAndGet();
        }
    }
}

