/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.gui;

import de.mediathekview.mlib.filmlisten.FilmlisteLesen;
import de.mediathekview.mlib.filmlisten.WriteFilmlistJson;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import mServer.crawler.gui.Data;
import mServer.crawler.gui.PanelDelController;
import mServer.crawler.gui.PanelSearchController;
import mServer.crawler.gui.PanelToolController;

public class MSearchGuiController
implements Initializable {
    @FXML
    private Parent fxPanelSearch;
    @FXML
    private PanelSearchController fxPanelSearchController;
    @FXML
    private Parent fxPanelDel;
    @FXML
    private PanelDelController fxPanelDelController;
    @FXML
    private Parent fxPanelTool;
    @FXML
    private PanelToolController fxPanelToolController;
    @FXML
    private TextField txtFilmList;
    @FXML
    public Label lblSum;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnSelect;
    @FXML
    private Button btnDelete;

    public void initialize(URL url, ResourceBundle resourceBundle) {
        Data.mlibGuiController = this;
        this.initPanelGui();
    }

    private void initPanelGui() {
        if (Data.pathFilmlist.isEmpty()) {
            this.txtFilmList.setText(System.getProperty("user.home") + File.separator + ".mediathek3" + File.separator + "filme.json");
        } else {
            this.txtFilmList.setText(Data.pathFilmlist);
        }
        new FilmlisteLesen().readFilmListe(this.txtFilmList.getText(), Data.listeFilme, 0);
        this.lblSum.setText(Data.listeFilme.size() + "");
        this.btnDelete.setOnAction(e -> {
            Data.listeFilme.clear();
            this.lblSum.setText(Data.listeFilme.size() + "");
        });
        this.btnSave.setOnAction(e -> new WriteFilmlistJson().filmlisteSchreibenJson(this.txtFilmList.getText(), Data.listeFilme));
        this.btnSelect.setOnAction(e -> this.getPath());
    }

    private void getPath() {
        File f;
        FileChooser chooser = new FileChooser();
        if (!this.txtFilmList.getText().equals("")) {
            chooser.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        if ((f = chooser.showOpenDialog(null)) != null) {
            try {
                this.txtFilmList.setText(f.getAbsolutePath());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

