/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class MediathekOrf
extends MediathekReader {
    public static final String SENDERNAME = "ORF";
    private static final String THEMA_TAG = "-1";
    private static final String THEMA_SENDUNGEN = "-2";

    public MediathekOrf(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 100, startPrio);
    }

    @Override
    protected void addToList() {
        MSStringBuilder seite = new MSStringBuilder(65536);
        this.listeThemen.clear();
        this.meldungStart();
        if (CrawlerTool.loadLongMax()) {
            this.bearbeiteAdresseSendung(seite);
        }
        MediathekOrf.listeSort(this.listeThemen, 1);
        int maxTage = CrawlerTool.loadLongMax() ? 9 : 2;
        for (int i = 0; i < maxTage; ++i) {
            String vorTagen = this.getGestern(i).toLowerCase();
            this.bearbeiteAdresseTag("http://tvthek.orf.at/schedule/" + vorTagen, seite);
        }
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                ThemaLaden th = new ThemaLaden();
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void bearbeiteAdresseTag(String adresse, MSStringBuilder seite) {
        GetUrl getUrl = new GetUrl(100L);
        seite = getUrl.getUri(SENDERNAME, adresse, StandardCharsets.UTF_8, 2, seite, "");
        ArrayList<String> al = new ArrayList<String>();
        seite.extractList("", "", "<a href=\"http://tvthek.orf.at/profile/", "\"", "http://tvthek.orf.at/profile/", al);
        for (String s : al) {
            String[] add = new String[]{s, THEMA_TAG};
            if (this.istInListe(this.listeThemen, add[0], 0)) continue;
            this.listeThemen.add(add);
        }
    }

    private void bearbeiteAdresseSendung(MSStringBuilder seite) {
        String URL2 = "http://tvthek.orf.at/profiles";
        GetUrl getUrl = new GetUrl(100L);
        seite = getUrl.getUri(SENDERNAME, "http://tvthek.orf.at/profiles", StandardCharsets.UTF_8, 3, seite, "");
        ArrayList<String> al = new ArrayList<String>();
        try {
            seite.extractList("", "", "<a href=\"/profiles/letter/", "\"", "http://tvthek.orf.at/profiles/letter/", al);
            for (String s : al) {
                String[] add = new String[]{s, THEMA_SENDUNGEN};
                if (this.istInListe(this.listeThemen, add[0], 0)) continue;
                this.listeThemen.add(add);
            }
        }
        catch (Exception ex) {
            Log.errorLog(826341789, ex);
        }
    }

    private String getGestern(int tage) {
        try {
            FastDateFormat sdfOut = FastDateFormat.getInstance((String)"dd.MM.yyyy");
            return sdfOut.format(new Date(new Date().getTime() - (long)(tage * 86400000)));
        }
        catch (Exception ex) {
            return "";
        }
    }

    private class ThemaLaden
    extends Thread {
        private final GetUrl getUrl;
        private MSStringBuilder seite1;
        private MSStringBuilder seite2;
        private final ArrayList<String> alSendung;
        private final ArrayList<String> urlList;

        private ThemaLaden() {
            this.getUrl = new GetUrl(MediathekOrf.this.getWartenSeiteLaden());
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
            this.alSendung = new ArrayList();
            this.urlList = new ArrayList();
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekOrf.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekOrf.this.listeThemen.getListeThemen()) != null) {
                    try {
                        MediathekOrf.this.meldungProgress(link[0]);
                        switch (link[1]) {
                            case "-1": {
                                this.feedEinerSeiteSuchen(link[0], true);
                                break;
                            }
                            case "-2": {
                                this.sendungen(link[0]);
                            }
                        }
                    }
                    catch (Exception ex) {
                        Log.errorLog(795633581, ex);
                    }
                }
            }
            catch (Exception ex) {
                Log.errorLog(554012398, ex);
            }
            MediathekOrf.this.meldungThreadUndFertig();
        }

        private void sendungen(String url) {
            GetUrl getUrl = new GetUrl(100L);
            this.seite1 = getUrl.getUri(MediathekOrf.SENDERNAME, url, StandardCharsets.UTF_8, 2, this.seite1, "");
            this.alSendung.clear();
            this.seite1.extractList("", "", "<a href=\"http://tvthek.orf.at/profile/", "\"", "http://tvthek.orf.at/profile/", this.alSendung);
            for (String s : this.alSendung) {
                try {
                    if (Config.getStop() || s.startsWith("http://tvthek.orf.at/profile/Archiv/")) break;
                    this.feedEinerSeiteSuchen(s, false);
                }
                catch (Exception ex) {
                    Log.errorLog(702095478, ex);
                }
            }
        }

        private void feedEinerSeiteSuchen(String strUrlFeed, boolean nurUrlPruefen) {
            this.seite2 = this.getUrl.getUri_Utf(MediathekOrf.SENDERNAME, strUrlFeed, this.seite2, "");
            long duration = 0L;
            String urlRtmpKlein = "";
            String urlRtmp = "";
            int pos = 0;
            MediathekOrf.this.meldung(strUrlFeed);
            String thema = this.seite2.extract("<title>", "vom");
            String datum = this.seite2.extract("<span class=\"meta meta_date\">", "<");
            if (datum.contains(",")) {
                datum = datum.substring(datum.indexOf(44) + 1).trim();
            }
            String zeit = this.seite2.extract("<span class=\"meta meta_time\">", "<");
            if ((zeit = zeit.replace("Uhr", "").trim()).length() == 5) {
                zeit = zeit.replace(".", ":") + ":00";
            }
            boolean onlyOne = false;
            int posStart = this.seite2.indexOf("<!-- start playlist -->");
            int posStopAlles = this.seite2.indexOf("<!-- ende: playlist -->", posStart);
            if (posStart < 0 || posStopAlles < 0) {
                posStart = this.seite2.indexOf("<!-- start: player -->");
                posStopAlles = this.seite2.indexOf("<div class=\"service_footer\">", posStart);
                onlyOne = true;
            }
            String MUSTER_SUCHEN = "<li class=\"base_list_item segment_";
            while (onlyOne || (pos = this.seite2.indexOf("<li class=\"base_list_item segment_", pos)) != -1) {
                String description;
                String titel;
                int posStopEpisode;
                if (onlyOne) {
                    posStopEpisode = posStopAlles;
                    onlyOne = false;
                    titel = this.seite2.extract("<h3 class=\"video_headline\">", "<", pos, posStopEpisode);
                    if (!titel.equals(StringEscapeUtils.unescapeJava((String)titel))) {
                        titel = StringEscapeUtils.unescapeJava((String)titel).trim();
                    }
                } else {
                    posStopEpisode = this.seite2.indexOf("</footer>", pos);
                    if (posStopEpisode == -1 || posStopEpisode > posStopAlles || pos > posStopAlles) break;
                    titel = this.seite2.extract("<h4 class=\"base_list_item_headline\">", "<", pos, posStopEpisode);
                    if (!titel.equals(StringEscapeUtils.unescapeJava((String)titel))) {
                        titel = StringEscapeUtils.unescapeJava((String)titel).trim();
                    }
                }
                String tmp = this.seite2.extract("&quot;duration&quot;:", ",", pos += "<li class=\"base_list_item segment_".length(), posStopEpisode);
                try {
                    duration = Long.parseLong(tmp) / 1000L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String subtitle = this.seite2.extract("{&quot;src&quot;:&quot;", "&quot", pos, posStopEpisode);
                if (!subtitle.isEmpty()) {
                    subtitle = subtitle.replace("\\/", "/");
                    subtitle = subtitle.replace("%2F", "/");
                }
                if ((description = this.seite2.extract("<div class=\"details\">", "</div>", pos, posStopEpisode).trim()).isEmpty()) {
                    description = this.seite2.extract("<div class=\"details_description\">", "</div>", pos, posStopEpisode).trim();
                }
                if (description.isEmpty()) {
                    description = this.seite2.extract("&quot;description&quot;:&quot;", "&quot", pos, posStopEpisode).trim();
                }
                if (!description.equals(StringEscapeUtils.unescapeJava((String)description))) {
                    description = StringEscapeUtils.unescapeJava((String)description).trim();
                }
                if (description.isEmpty()) {
                    Log.errorLog(989532147, "keine Beschreibung: " + strUrlFeed);
                }
                String url = "";
                String urlHD = "";
                String urlKlein = "";
                String MUSTER_URL = "{&quot;quality&quot;:&quot;Q6A&quot;,&quot;quality_string&quot;:&quot;hoch&quot;,&quot;src&quot;:&quot;http";
                String MUSTER_URL_HD = "quality&quot;:&quot;Q8C&quot;,&quot;quality_string&quot;:&quot;sehr hoch (HD)&quot;,&quot;src&quot;:&quot;http";
                String MUSTER_URL_KLEIN = "quality&quot;:&quot;Q4A&quot;,&quot;quality_string&quot;:&quot;mittel&quot;,&quot;src&quot;:&quot;http";
                this.urlList.clear();
                this.seite2.extractList(pos, posStopEpisode, "{&quot;quality&quot;:&quot;Q6A&quot;,&quot;quality_string&quot;:&quot;hoch&quot;,&quot;src&quot;:&quot;http", "", "&quot;", "http", this.urlList);
                for (String u : this.urlList) {
                    if (!u.endsWith(".mp4")) continue;
                    url = u.replace("\\/", "/");
                    break;
                }
                this.urlList.clear();
                this.seite2.extractList(pos, posStopEpisode, "quality&quot;:&quot;Q8C&quot;,&quot;quality_string&quot;:&quot;sehr hoch (HD)&quot;,&quot;src&quot;:&quot;http", "", "&quot;", "http", this.urlList);
                for (String u : this.urlList) {
                    if (!u.endsWith(".mp4")) continue;
                    urlHD = u.replace("\\/", "/");
                    break;
                }
                this.urlList.clear();
                this.seite2.extractList(pos, posStopEpisode, "quality&quot;:&quot;Q4A&quot;,&quot;quality_string&quot;:&quot;mittel&quot;,&quot;src&quot;:&quot;http", "", "&quot;", "http", this.urlList);
                for (String u : this.urlList) {
                    if (!u.endsWith(".mp4")) continue;
                    urlKlein = u.replace("\\/", "/");
                    break;
                }
                if (!url.isEmpty()) {
                    if (thema.isEmpty()) {
                        thema = MediathekOrf.SENDERNAME;
                    }
                    if (titel.isEmpty()) {
                        titel = MediathekOrf.SENDERNAME;
                    }
                    DatenFilm film = new DatenFilm(MediathekOrf.SENDERNAME, thema, strUrlFeed, titel, url, urlRtmp, datum, zeit, duration, description);
                    if (!urlKlein.isEmpty()) {
                        CrawlerTool.addUrlKlein(film, urlKlein, urlRtmpKlein);
                    }
                    if (!urlHD.isEmpty()) {
                        CrawlerTool.addUrlHd(film, urlHD, "");
                    }
                    if (!subtitle.isEmpty()) {
                        CrawlerTool.addUrlSubtitle(film, subtitle);
                    }
                    MediathekOrf.this.addFilm(film, nurUrlPruefen);
                    continue;
                }
                Log.errorLog(989532147, "keine Url: " + strUrlFeed);
            }
        }
    }
}

