/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.orf.parser;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Optional;
import mServer.crawler.sender.orf.JsonUtils;
import mServer.crawler.sender.orf.OrfEpisodeInfoDTO;
import mServer.crawler.sender.orf.OrfVideoInfoDTO;
import mServer.crawler.sender.orf.parser.OrfVideoDetailDeserializer;

public class OrfEpisodeDeserializer
implements JsonDeserializer<Optional<OrfEpisodeInfoDTO>> {
    private static final String ELEMENT_VIDEO = "video";
    private static final String ATTRIBUTE_TITLE = "title";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_DURATION = "duration";

    public Optional<OrfEpisodeInfoDTO> deserialize(JsonElement aJsonElement, Type aType, JsonDeserializationContext aContext) throws JsonParseException {
        if (!aJsonElement.getAsJsonObject().has(ELEMENT_VIDEO)) {
            return Optional.empty();
        }
        JsonObject videoObject = aJsonElement.getAsJsonObject().get(ELEMENT_VIDEO).getAsJsonObject();
        Optional<String> title = JsonUtils.getAttributeAsString(videoObject, ATTRIBUTE_TITLE);
        Optional<String> description = JsonUtils.getAttributeAsString(videoObject, ATTRIBUTE_DESCRIPTION);
        Optional<Duration> duration = OrfEpisodeDeserializer.parseDuration(videoObject);
        Optional<OrfVideoInfoDTO> videoInfoOptional = this.parseUrls(videoObject);
        if (videoInfoOptional.isPresent()) {
            OrfEpisodeInfoDTO episode = new OrfEpisodeInfoDTO(videoInfoOptional.get(), title, description, duration);
            return Optional.of(episode);
        }
        return Optional.empty();
    }

    private Optional<OrfVideoInfoDTO> parseUrls(JsonObject aVideoObject) {
        OrfVideoDetailDeserializer deserializer = new OrfVideoDetailDeserializer();
        return deserializer.deserializeVideoObject(aVideoObject);
    }

    private static Optional<Duration> parseDuration(JsonObject aVideoObject) {
        if (aVideoObject.has(ATTRIBUTE_DURATION)) {
            Long durationValue = aVideoObject.get(ATTRIBUTE_DURATION).getAsLong();
            return Optional.of(Duration.ofSeconds(durationValue / 1000L));
        }
        return Optional.empty();
    }
}

