/*
 * Decompiled with CFR 0.152.
 */
package mServer.tool;

import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmPoint;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import mServer.daten.MserverDatenUpload;
import mServer.daten.MserverSearchTask;
import mServer.tool.MserverDaten;
import mServer.tool.MserverKonstanten;
import mServer.tool.MserverLog;

public class MserverXmlLesen {
    private static final EtmMonitor etmMonitor = EtmManager.getEtmMonitor();

    public static void xmlDatenLesen() {
        MserverXmlLesen.xmlDatenLesen(MserverDaten.getKonfigDatei());
        MserverXmlLesen.xmlDatenLesen(MserverDaten.getUploadDatei());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void xmlDatenLesen(String datei) {
        EtmPoint performancePoint = etmMonitor.createPoint("MserverXmlLesen:xmlDatenLesen");
        try {
            if (new File(datei).exists()) {
                XMLInputFactory inFactory = XMLInputFactory.newInstance();
                inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
                InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(datei), StandardCharsets.UTF_8);
                XMLStreamReader parser = inFactory.createXMLStreamReader(in);
                while (parser.hasNext()) {
                    int event = parser.next();
                    if (event != 1) continue;
                    if (parser.getLocalName().equals("system")) {
                        MserverXmlLesen.get(parser, event, "system", MserverKonstanten.SYSTEM_COLUMN_NAMES, MserverDaten.system);
                    }
                    if (parser.getLocalName().equals("suchen")) {
                        MserverSearchTask cron = new MserverSearchTask();
                        MserverXmlLesen.get(parser, event, "suchen", MserverSearchTask.SUCHEN_COLUMN_NAMES, cron.arr);
                        MserverDaten.listeSuchen.add(cron);
                    }
                    if (!parser.getLocalName().equals("upload")) continue;
                    MserverDatenUpload upload = new MserverDatenUpload();
                    MserverXmlLesen.get(parser, event, "upload", MserverDatenUpload.UPLOAD_COLUMN_NAMES, upload.arr);
                    MserverDaten.listeUpload.add(upload);
                }
            }
        }
        catch (Exception ex) {
            MserverLog.fehlerMeldung(909078531, MserverXmlLesen.class.getName(), "xmlDatenLesen", ex);
        }
        finally {
            performancePoint.collect();
        }
    }

    private static boolean get(XMLStreamReader parser, int event, String xmlElem, String[] xmlNames, String[] strRet) {
        return MserverXmlLesen.get(parser, event, xmlElem, xmlNames, strRet, true);
    }

    private static boolean get(XMLStreamReader parser, int event, String xmlElem, String[] xmlNames, String[] strRet, boolean log) {
        boolean ret;
        EtmPoint performancePoint;
        block5: {
            int i;
            performancePoint = etmMonitor.createPoint("MserverXmlLesen:get");
            ret = true;
            int maxElem = strRet.length;
            for (i = 0; i < maxElem; ++i) {
                if (strRet[i] != null) continue;
                strRet[i] = "";
            }
            try {
                block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                    if (event != 1) continue;
                    for (i = 0; i < maxElem; ++i) {
                        if (!parser.getLocalName().equals(xmlNames[i])) continue;
                        strRet[i] = parser.getElementText().trim();
                        continue block3;
                    }
                }
            }
            catch (Exception ex) {
                ret = false;
                if (!log) break block5;
                MserverLog.fehlerMeldung(201456980, MserverXmlLesen.class.getName(), "get", ex);
            }
        }
        performancePoint.collect();
        return ret;
    }
}

