/*
 * Decompiled with CFR 0.152.
 */
package de.mediathekview.mlib.daten;

import de.mediathekview.mlib.tool.DatumFilm;
import de.mediathekview.mlib.tool.FileSize;
import de.mediathekview.mlib.tool.Functions;
import de.mediathekview.mlib.tool.GermanStringSorter;
import de.mediathekview.mlib.tool.Hash;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSLong;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;

public class DatenFilm
implements Comparable<DatenFilm> {
    private static final String COPYRIGHT_CHAR_HTML = "&copy;";
    public static final String AUFLOESUNG_NORMAL = "normal";
    public static final String AUFLOESUNG_HD = "hd";
    public static final String AUFLOESUNG_KLEIN = "klein";
    public static final String GEO_DE = "DE";
    public static final String GEO_AT = "AT";
    public static final String GEO_CH = "CH";
    public static final String GEO_EU = "EU";
    public static final String GEO_WELT = "WELT";
    public static final int FILM_NR = 0;
    public static final int FILM_SENDER = 1;
    public static final int FILM_THEMA = 2;
    public static final int FILM_TITEL = 3;
    public static final int FILM_ABSPIELEN = 4;
    public static final int FILM_AUFZEICHNEN = 5;
    public static final int FILM_DATUM = 6;
    public static final int FILM_ZEIT = 7;
    public static final int FILM_DAUER = 8;
    public static final int FILM_GROESSE = 9;
    public static final int FILM_HD = 10;
    public static final int FILM_UT = 11;
    public static final int FILM_BESCHREIBUNG = 12;
    public static final int FILM_GEO = 13;
    public static final int FILM_URL = 14;
    public static final int FILM_WEBSEITE = 15;
    public static final int FILM_ABO_NAME = 16;
    public static final int FILM_URL_SUBTITLE = 17;
    public static final int FILM_URL_RTMP = 18;
    public static final int FILM_URL_AUTH = 19;
    public static final int FILM_URL_KLEIN = 20;
    public static final int FILM_URL_RTMP_KLEIN = 21;
    public static final int FILM_URL_HD = 22;
    public static final int FILM_URL_RTMP_HD = 23;
    public static final int FILM_URL_HISTORY = 24;
    public static final int FILM_NEU = 25;
    public static final int FILM_DATUM_LONG = 26;
    public static final int FILM_REF = 27;
    public static final int MAX_ELEM = 28;
    public static final String TAG = "Filme";
    public static final String TAG_JSON_LIST = "X";
    public static final String[] COLUMN_NAMES = new String[]{"Nr", "Sender", "Thema", "Titel", "", "", "Datum", "Zeit", "Dauer", "Gr\u00f6\u00dfe [MB]", "HD", "UT", "Beschreibung", "Geo", "Url", "Website", "Abo", "Url Untertitel", "Url RTMP", "Url Auth", "Url Klein", "Url RTMP Klein", "Url HD", "Url RTMP HD", "Url History", "neu", "DatumL", "Ref"};
    public static final int[] JSON_NAMES = new int[]{1, 2, 3, 6, 7, 8, 9, 12, 14, 15, 17, 18, 20, 21, 22, 23, 26, 24, 13, 25};
    private static final GermanStringSorter sorter = GermanStringSorter.getInstance();
    private static final FastDateFormat sdf_datum_zeit = FastDateFormat.getInstance((String)"dd.MM.yyyyHH:mm:ss");
    private static final FastDateFormat sdf_datum = FastDateFormat.getInstance((String)"dd.MM.yyyy");
    private static final String[] GERMAN_ONLY = new String[]{"+++ Aus rechtlichen Gr\u00fcnden ist der Film nur innerhalb von Deutschland abrufbar. +++", "+++ Aus rechtlichen Gr\u00fcnden ist diese Sendung nur innerhalb von Deutschland abrufbar. +++", "+++ Aus rechtlichen Gr\u00fcnden ist dieses Video nur innerhalb von Deutschland abrufbar. +++", "+++ Aus rechtlichen Gr\u00fcnden ist dieses Video nur innerhalb von Deutschland verf\u00fcgbar. +++", "+++ Aus rechtlichen Gr\u00fcnden kann das Video nur innerhalb von Deutschland abgerufen werden. +++ Due to legal reasons the video is only available in Germany.+++", "+++ Aus rechtlichen Gr\u00fcnden kann das Video nur innerhalb von Deutschland abgerufen werden. +++", "+++ Due to legal reasons the video is only available in Germany.+++", "+++ Aus rechtlichen Gr\u00fcnden kann das Video nur in Deutschland abgerufen werden. +++", "[Aus rechtlichen G\u00fcnden k\u00f6nnen wir die Partie nicht als Einzelclip anbieten.]", "+++ Aus rechtlichen Gr\u00fcnden ist das Video nur innerhalb von Deutschland abrufbar. +++", "+++Aus rechtlichen Gr\u00fcnden kann die Sendung nur innerhalb von Deutschland abgerufen werden. +++", "+++ Aus rechtlichen Gr\u00fcnden d\u00fcrfen wir dieses Video nur innerhalb von Deutschland anbieten. +++", "+++Aus rechtlichen Gr\u00fcnden kann dieses Video nur innerhalb von Deutschland abgerufen werden.+++"};
    public static boolean[] spaltenAnzeigen = new boolean[28];
    public final String[] arr = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    public DatumFilm datumFilm = new DatumFilm(0L);
    public long dauerL = 0L;
    public Object abo = null;
    public MSLong dateigroesseL = new MSLong(0L);
    public int nr;
    private boolean neuerFilm = false;
    private Hash hashValueIndexAddOld = null;
    private Hash hashValueUrl = null;

    public DatenFilm() {
        this.dateigroesseL = new MSLong(0L);
    }

    public DatenFilm(String ssender, String tthema, String filmWebsite, String ttitel, String uurl, String uurlRtmp, String datum, String zeit, long dauerSekunden, String description) {
        this.arr[1] = ssender;
        this.arr[2] = tthema.isEmpty() ? ssender : tthema.trim();
        this.setTitle(ttitel.isEmpty() ? tthema : ttitel.trim());
        this.arr[14] = uurl;
        this.arr[18] = uurlRtmp;
        this.arr[15] = filmWebsite;
        this.checkDatum(datum, this.arr[1] + ' ' + this.arr[2] + ' ' + this.arr[3]);
        this.checkZeit(this.arr[6], zeit, this.arr[1] + ' ' + this.arr[2] + ' ' + this.arr[3]);
        this.arr[12] = DatenFilm.cleanDescription(description, tthema, ttitel);
        this.checkFilmDauer(dauerSekunden);
    }

    private void setTitle(String title) {
        if (title.contains(COPYRIGHT_CHAR_HTML)) {
            title = title.substring(0, title.indexOf(COPYRIGHT_CHAR_HTML));
            title = title.trim();
        }
        this.arr[3] = title;
    }

    public void setFileSize() {
        if (this.arr[9].isEmpty()) {
            this.arr[9] = FileSize.laengeString(this.arr[14]);
        }
    }

    public static String cleanDescription(String s, String thema, String titel) {
        s = Functions.removeHtml(s);
        for (String g : GERMAN_ONLY) {
            if (!s.contains(g)) continue;
            s = s.replace(g, "");
        }
        if (s.startsWith(titel)) {
            s = s.substring(titel.length()).trim();
        }
        if (s.startsWith(thema)) {
            s = s.substring(thema.length()).trim();
        }
        if (s.startsWith("|")) {
            s = s.substring(1).trim();
        }
        if (s.startsWith("Video-Clip")) {
            s = s.substring("Video-Clip".length()).trim();
        }
        if (s.startsWith(titel)) {
            s = s.substring(titel.length()).trim();
        }
        if (s.startsWith(":") || s.startsWith(",") || s.startsWith("\n")) {
            s = s.substring(1).trim();
        }
        if (s.contains("\\\"")) {
            s = s.replace("\\\"", "\"");
        }
        if (s.length() > 400) {
            return s.substring(0, 400) + "\n.....";
        }
        return s;
    }

    public boolean isNew() {
        return this.neuerFilm;
    }

    public void setNew(boolean newFilm) {
        this.neuerFilm = newFilm;
    }

    private void checkFilmDauer(long dauerSekunden) {
        if (dauerSekunden <= 0L || dauerSekunden > 18000L) {
            this.arr[8] = "";
        } else {
            String hours = String.valueOf(dauerSekunden / 3600L);
            String min = String.valueOf((dauerSekunden %= 3600L) / 60L);
            String seconds = String.valueOf(dauerSekunden % 60L);
            this.arr[8] = this.fuellen(2, hours) + ':' + this.fuellen(2, min) + ':' + this.fuellen(2, seconds);
        }
    }

    public String getUrlSubtitle() {
        return this.arr[17];
    }

    public boolean hasUT() {
        return !this.arr[17].isEmpty();
    }

    public String getUrlFuerAufloesung(String aufloesung) {
        if (aufloesung.equals(AUFLOESUNG_KLEIN)) {
            return this.getUrlNormalKlein();
        }
        if (aufloesung.equals(AUFLOESUNG_HD)) {
            return this.getUrlNormalHd();
        }
        return this.arr[14];
    }

    public String getUrlRtmpFuerAufloesung(String aufloesung) {
        if (aufloesung.equals(AUFLOESUNG_KLEIN)) {
            return this.getUrlFlvstreamerKlein();
        }
        if (aufloesung.equals(AUFLOESUNG_HD)) {
            return this.getUrlFlvstreamerHd();
        }
        return this.getUrlFlvstreamer();
    }

    public String getDateigroesse(String url) {
        if (url.equals(this.arr[14])) {
            return this.arr[9];
        }
        return FileSize.laengeString(url);
    }

    public void setUrlHistory() {
        String u = this.getUrl();
        this.arr[24] = u.equals(this.arr[14]) ? "" : u;
    }

    public String getUrlHistory() {
        if (this.arr[24].isEmpty()) {
            return this.arr[14];
        }
        return this.arr[24];
    }

    public String getIndex() {
        return (this.arr[1] + this.arr[2]).toLowerCase() + this.getUrl();
    }

    public String getIndexAddOld() {
        return this.arr[1] + this.repl(this.arr[2]) + this.repl(this.arr[3]);
    }

    private String repl(String s) {
        return s.replace("-", "").replace("_", "").replace(".", "").replace(" ", "").replace(",", "").toLowerCase();
    }

    public Hash getHashValueIndexAddOld() {
        if (this.hashValueIndexAddOld == null) {
            this.hashValueIndexAddOld = new Hash(this.getIndexAddOld());
        }
        return this.hashValueIndexAddOld;
    }

    public Hash getHashValueUrl() {
        if (this.hashValueUrl == null) {
            this.hashValueUrl = new Hash(this.getUrl());
        }
        return this.hashValueUrl;
    }

    public String getUrl() {
        String url = "";
        if (this.arr[1].equals("ORF")) {
            String uurl = this.arr[14];
            try {
                String online = "/online/";
                url = uurl.substring(uurl.indexOf("/online/") + "/online/".length());
                if (!url.contains("/")) {
                    Log.errorLog(915230478, "Url: " + uurl);
                    return "";
                }
                if (!(url = url.substring(url.indexOf(47) + 1)).contains("/")) {
                    Log.errorLog(915230478, "Url: " + uurl);
                    return "";
                }
                if ((url = url.substring(url.indexOf(47) + 1)).isEmpty()) {
                    Log.errorLog(915230478, "Url: " + uurl);
                    return "";
                }
            }
            catch (Exception ex) {
                Log.errorLog(915230478, ex, "Url: " + uurl);
            }
            return "ORF----" + url;
        }
        return this.arr[14];
    }

    public boolean isHD() {
        return !this.arr[22].isEmpty() || !this.arr[23].isEmpty();
    }

    public DatenFilm getCopy() {
        DatenFilm ret = new DatenFilm();
        System.arraycopy(this.arr, 0, ret.arr, 0, this.arr.length);
        ret.datumFilm = this.datumFilm;
        ret.nr = this.nr;
        ret.dateigroesseL = this.dateigroesseL;
        ret.dauerL = this.dauerL;
        ret.abo = this.abo;
        return ret;
    }

    @Override
    public int compareTo(DatenFilm arg0) {
        int ret = sorter.compare(this.arr[1], arg0.arr[1]);
        if (ret == 0) {
            return sorter.compare(this.arr[2], arg0.arr[2]);
        }
        return ret;
    }

    private void preserveMemory() {
        if (this.arr[9].length() < 3) {
            this.arr[9] = this.arr[9].intern();
        }
        if (this.arr[20].length() < 15) {
            this.arr[20] = this.arr[20].intern();
        }
        this.arr[6] = this.arr[6].intern();
        this.arr[7] = this.arr[7].intern();
    }

    private void setFilmdauer() {
        try {
            if (!this.arr[8].contains(":") && !this.arr[8].isEmpty()) {
                long l;
                this.dauerL = l = Long.parseLong(this.arr[8]);
                if (l > 0L) {
                    long hours = l / 3600L;
                    long min = (l -= hours * 3600L) / 60L;
                    long seconds = l -= min * 60L;
                    this.arr[8] = this.fuellen(2, String.valueOf(hours)) + ':' + this.fuellen(2, String.valueOf(min)) + ':' + this.fuellen(2, String.valueOf(seconds));
                } else {
                    this.arr[8] = "";
                }
            } else {
                this.dauerL = 0L;
                if (!this.arr[8].isEmpty()) {
                    String[] parts = this.arr[8].split(":");
                    long power = 1L;
                    for (int i = parts.length - 1; i >= 0; --i) {
                        this.dauerL += Long.parseLong(parts[i]) * power;
                        power *= 60L;
                    }
                }
            }
        }
        catch (Exception ex) {
            this.dauerL = 0L;
            Log.errorLog(468912049, "Dauer: " + this.arr[8]);
        }
    }

    private void setDatum() {
        if (!this.arr[6].isEmpty()) {
            try {
                if (this.arr[26].isEmpty()) {
                    this.datumFilm = this.arr[7].isEmpty() ? new DatumFilm(sdf_datum.parse(this.arr[6]).getTime()) : new DatumFilm(sdf_datum_zeit.parse(this.arr[6] + this.arr[7]).getTime());
                    this.arr[26] = String.valueOf(this.datumFilm.getTime() / 1000L);
                } else {
                    long l = Long.parseLong(this.arr[26]);
                    this.datumFilm = new DatumFilm(l * 1000L);
                }
            }
            catch (Exception ex) {
                Log.errorLog(915236701, ex, new String[]{"Datum: " + this.arr[6], "Zeit: " + this.arr[7]});
                this.datumFilm = new DatumFilm(0L);
                this.arr[6] = "";
                this.arr[7] = "";
            }
        }
    }

    public void init() {
        this.preserveMemory();
        this.dateigroesseL = new MSLong(this);
        this.setFilmdauer();
        this.setDatum();
    }

    private String getUrlNormalKlein() {
        if (!this.arr[20].isEmpty()) {
            try {
                int i = Integer.parseInt(this.arr[20].substring(0, this.arr[20].indexOf(124)));
                return this.arr[14].substring(0, i) + this.arr[20].substring(this.arr[20].indexOf(124) + 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.arr[14];
    }

    private String getUrlNormalHd() {
        if (!this.arr[22].isEmpty()) {
            try {
                int i = Integer.parseInt(this.arr[22].substring(0, this.arr[22].indexOf(124)));
                return this.arr[14].substring(0, i) + this.arr[22].substring(this.arr[22].indexOf(124) + 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.arr[14];
    }

    private String getUrlFlvstreamer() {
        String ret = !this.arr[18].isEmpty() ? this.arr[18] : (this.arr[14].startsWith("rtmp") ? "-r " + this.arr[14] : this.arr[14]);
        return ret;
    }

    private String getUrlFlvstreamerKlein() {
        String ret;
        if (!this.arr[21].isEmpty()) {
            try {
                int i = Integer.parseInt(this.arr[21].substring(0, this.arr[21].indexOf(124)));
                return this.arr[18].substring(0, i) + this.arr[21].substring(this.arr[21].indexOf(124) + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.arr[18].isEmpty()) {
            ret = this.arr[18];
        } else {
            ret = this.getUrlNormalKlein();
            if (ret.startsWith("rtmp")) {
                ret = "-r " + ret;
            }
        }
        return ret;
    }

    private String getUrlFlvstreamerHd() {
        if (!this.arr[23].isEmpty()) {
            try {
                int i = Integer.parseInt(this.arr[23].substring(0, this.arr[23].indexOf(124)));
                return this.arr[18].substring(0, i) + this.arr[23].substring(this.arr[23].indexOf(124) + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getUrlFlvstreamer();
    }

    private void checkDatum(String datum, String fehlermeldung) {
        long MAX = 8640000000L;
        if ((datum = datum.trim()).contains(".") && datum.length() == 10) {
            try {
                Date filmDate = FastDateFormat.getInstance((String)"dd.MM.yyyy").parse(datum);
                if (filmDate.getTime() < 0L) {
                    Log.errorLog(923012125, "Unsinniger Wert: [" + datum + "] " + fehlermeldung);
                } else if (new Date().getTime() + 8640000000L < filmDate.getTime()) {
                    Log.errorLog(121305469, "Unsinniger Wert: [" + datum + "] " + fehlermeldung);
                } else {
                    this.arr[6] = datum;
                }
            }
            catch (Exception ex) {
                Log.errorLog(794630593, ex);
                Log.errorLog(946301596, '[' + datum + "] " + fehlermeldung);
            }
        }
    }

    private void checkZeit(String datum, String zeit, String fehlermeldung) {
        zeit = zeit.trim();
        if (!datum.isEmpty() && !zeit.isEmpty()) {
            if (zeit.contains(":") && zeit.length() == 8) {
                this.arr[7] = zeit;
            } else {
                Log.errorLog(159623647, '[' + zeit + "] " + fehlermeldung);
            }
        }
    }

    private String fuellen(int anz, String s) {
        while (s.length() < anz) {
            s = '0' + s;
        }
        return s;
    }
}

