/*
 * Decompiled with CFR 0.152.
 */
package de.mediathekview.mlib.filmlisten;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.filmlisten.DatenFilmlisteUrl;
import de.mediathekview.mlib.filmlisten.ListeFilmlistenUrls;
import de.mediathekview.mlib.tool.Functions;
import de.mediathekview.mlib.tool.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Random;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class FilmlistenSuchen {
    public ListeFilmlistenUrls listeFilmlistenUrls_akt = new ListeFilmlistenUrls();
    public ListeFilmlistenUrls listeFilmlistenUrls_diff = new ListeFilmlistenUrls();
    private static boolean firstSearchAkt = true;
    private static boolean firstSearchDiff = true;
    private final int UPDATE_LISTE_MAX = 10;

    public String suchenAkt(ArrayList<String> bereitsVersucht) {
        int nr;
        if (this.listeFilmlistenUrls_akt.isEmpty()) {
            this.updateURLsFilmlisten(true);
        } else if (firstSearchAkt && (nr = new Random().nextInt(10)) == 0) {
            this.updateURLsFilmlisten(true);
        }
        firstSearchAkt = false;
        String retUrl = this.listeFilmlistenUrls_akt.getRand(bereitsVersucht);
        if (bereitsVersucht != null) {
            bereitsVersucht.add(retUrl);
        }
        return retUrl;
    }

    public String suchenDiff(ArrayList<String> bereitsVersucht) {
        int nr;
        if (this.listeFilmlistenUrls_diff.isEmpty()) {
            this.updateURLsFilmlisten(false);
        } else if (firstSearchDiff && (nr = new Random().nextInt(10)) == 0) {
            this.updateURLsFilmlisten(false);
        }
        firstSearchDiff = false;
        String retUrl = this.listeFilmlistenUrls_diff.getRand(bereitsVersucht);
        if (bereitsVersucht != null) {
            bereitsVersucht.add(retUrl);
        }
        return retUrl;
    }

    private void insertDefaultActiveServers() {
        this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://m.picn.de/f/Filmliste-akt.xz", "akt"));
        this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://m1.picn.de/f/Filmliste-akt.xz", "akt"));
        this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://m2.picn.de/f/Filmliste-akt.xz", "akt"));
        this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://download10.onlinetvrecorder.com/mediathekview/Filmliste-akt.xz", "akt"));
        this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://mediathekview.jankal.me/Filmliste-akt.xz", "akt"));
        this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://verteiler1.mediathekview.de/Filmliste-akt.xz", "akt"));
        this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://verteiler2.mediathekview.de/Filmliste-akt.xz", "akt"));
        this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://verteiler3.mediathekview.de/Filmliste-akt.xz", "akt"));
    }

    private void insertDefaultDifferentialListServers() {
        this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://m.picn.de/f/Filmliste-diff.xz", "diff"));
        this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://m1.picn.de/f/Filmliste-diff.xz", "diff"));
        this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://m2.picn.de/f/Filmliste-diff.xz", "diff"));
        this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://download10.onlinetvrecorder.com/mediathekview/Filmliste-diff.xz", "diff"));
        this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://mediathekview.jankal.me/Filmliste-diff.xz", "diff"));
        this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://verteiler1.mediathekview.de/Filmliste-diff.xz", "diff"));
        this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://verteiler2.mediathekview.de/Filmliste-diff.xz", "diff"));
        this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://verteiler3.mediathekview.de/Filmliste-diff.xz", "diff"));
    }

    public void updateURLsFilmlisten(boolean updateFullList) {
        ListeFilmlistenUrls tmp = new ListeFilmlistenUrls();
        if (updateFullList) {
            this.getDownloadUrlsFilmlisten("http://res.mediathekview.de/akt.xml", tmp, Config.getUserAgent(), "akt");
            if (!tmp.isEmpty()) {
                this.listeFilmlistenUrls_akt = tmp;
            } else if (this.listeFilmlistenUrls_akt.isEmpty()) {
                this.insertDefaultActiveServers();
            }
            this.listeFilmlistenUrls_akt.sort();
        } else {
            this.getDownloadUrlsFilmlisten("http://res.mediathekview.de/diff.xml", tmp, Config.getUserAgent(), "diff");
            if (!tmp.isEmpty()) {
                this.listeFilmlistenUrls_diff = tmp;
            } else if (this.listeFilmlistenUrls_diff.isEmpty()) {
                this.insertDefaultDifferentialListServers();
            }
            this.listeFilmlistenUrls_diff.sort();
        }
        if (tmp.isEmpty()) {
            Log.errorLog(491203216, new String[]{"Es ist ein Fehler aufgetreten!", "Es konnten keine Updateserver zum aktualisieren der Filme", "gefunden werden."});
        }
    }

    public void getDownloadUrlsFilmlisten(String dateiUrl, ListeFilmlistenUrls listeFilmlistenUrls, String userAgent, String art) {
        try {
            InputStreamReader inReader;
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            if (Functions.istUrl(dateiUrl)) {
                int timeout = 20000;
                URLConnection conn = new URL(dateiUrl).openConnection();
                conn.setRequestProperty("User-Agent", userAgent);
                conn.setReadTimeout(timeout);
                conn.setConnectTimeout(timeout);
                inReader = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);
            } else {
                File f = new File(dateiUrl);
                if (!f.exists()) {
                    return;
                }
                inReader = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);
            }
            XMLStreamReader parser = inFactory.createXMLStreamReader(inReader);
            while (parser.hasNext()) {
                String parsername;
                int event = parser.next();
                if (event != 1 || !(parsername = parser.getLocalName()).equals("Server")) continue;
                this.parseServerEntry(parser, listeFilmlistenUrls, art);
            }
        }
        catch (Exception ex) {
            Log.errorLog(821069874, ex, "Die URL-Filmlisten konnte nicht geladen werden: " + dateiUrl);
        }
    }

    private void parseServerEntry(XMLStreamReader parser, ListeFilmlistenUrls listeFilmlistenUrls, String art) {
        String serverUrl = "";
        String prio = "";
        try {
            while (parser.hasNext()) {
                int event = parser.next();
                if (event == 1) {
                    switch (parser.getLocalName()) {
                        case "URL": {
                            serverUrl = parser.getElementText();
                            break;
                        }
                        case "Prio": {
                            prio = parser.getElementText();
                        }
                    }
                }
                if (event != 2 || !parser.getLocalName().equals("Server")) continue;
                if (!serverUrl.equals("")) {
                    if (prio.equals("")) {
                        prio = "1";
                    }
                    listeFilmlistenUrls.addWithCheck(new DatenFilmlisteUrl(serverUrl, prio, art));
                }
                break;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }
}

