/*
 * Decompiled with CFR 0.152.
 */
package de.mediathekview.mlib.tool;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;

public class Duration {
    private static Date stopZeitStatic = new Date(System.currentTimeMillis());
    private static final DecimalFormat DF = new DecimalFormat("###,##0.00");
    private static int sum = 0;
    private static final ArrayList<Counter> COUNTER_LIST = new ArrayList();

    public static synchronized void counterStart(String text) {
        Counter cc = null;
        for (Counter c : COUNTER_LIST) {
            if (!c.text.equals(text)) continue;
            cc = c;
            break;
        }
        if (cc == null) {
            COUNTER_LIST.add(new Counter(text, 0));
        } else {
            cc.start = new Date();
        }
    }

    public static synchronized void counterStop(String text) {
        String kl;
        Throwable t = new Throwable();
        StackTraceElement methodCaller = t.getStackTrace()[2];
        String klasse = methodCaller.getClassName() + "." + methodCaller.getMethodName();
        try {
            kl = klasse;
            while (kl.contains(".") && !Character.isUpperCase(kl.charAt(0))) {
                kl = kl.substring(kl.indexOf(".") + 1);
            }
        }
        catch (Exception ignored) {
            kl = klasse;
        }
        String extra = "";
        Counter cc = null;
        for (Counter c : COUNTER_LIST) {
            if (!c.text.equals(text)) continue;
            cc = c;
            break;
        }
        if (cc != null) {
            ++cc.count;
            try {
                long time = Math.round(new Date().getTime() - cc.start.getTime());
                cc.time += time;
                extra = cc.text + " Anzahl: " + cc.count + "   Dauer: " + Duration.roundDuration(time);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Duration.staticPing(kl, text, extra);
    }

    public static synchronized void printCounter() {
        int max = 0;
        for (Counter c : COUNTER_LIST) {
            if (c.text.length() <= max) continue;
            max = c.text.length();
        }
        ++max;
        for (Counter c : COUNTER_LIST) {
            while (c.text.length() < max) {
                c.text = c.text + " ";
            }
        }
        System.out.println("");
        System.out.println("");
        System.out.println("#################################################################");
        for (Counter c : COUNTER_LIST) {
            System.out.println(c.text + " Anzahl: " + c.count + "   Gesamtdauer: " + Duration.roundDuration(c.time));
        }
        System.out.println("#################################################################");
        System.out.println("");
    }

    public static synchronized void staticPing(String text) {
        String kl;
        Throwable t = new Throwable();
        StackTraceElement methodCaller = t.getStackTrace()[2];
        String klasse = methodCaller.getClassName() + "." + methodCaller.getMethodName();
        try {
            kl = klasse;
            while (kl.contains(".") && !Character.isUpperCase(kl.charAt(0))) {
                kl = kl.substring(kl.indexOf(".") + 1);
            }
        }
        catch (Exception ignored) {
            kl = klasse;
        }
        Duration.staticPing(kl, text, "");
    }

    private static void staticPing(String klasse, String text, String extra) {
        long sekunden;
        Date now = new Date(System.currentTimeMillis());
        try {
            sekunden = Math.round(now.getTime() - stopZeitStatic.getTime());
        }
        catch (Exception ex) {
            sekunden = -1L;
        }
        System.out.println("");
        System.out.println("========== ========== ========== ========== ==========");
        System.out.println("DURATION " + sum++ + ":  " + text + "  [" + Duration.roundDuration(sekunden) + "]");
        System.out.println("   Klasse:  " + klasse);
        if (!extra.isEmpty()) {
            System.out.println("   " + extra);
        }
        System.out.println("========== ========== ========== ========== ==========");
        System.out.println("");
        stopZeitStatic = now;
    }

    public static String roundDuration(long s) {
        String ret = (double)s > 1000.0 ? DF.format((double)s / 1000.0) + " s" : DF.format(s) + " ms";
        return ret;
    }

    private static class Counter {
        String text;
        int count;
        long time;
        Date start;

        public Counter(String nr, int count) {
            this.text = nr;
            this.count = count;
            this.start = new Date();
        }
    }
}

