/*
 * Decompiled with CFR 0.152.
 */
package de.mediathekview.mlib.tool;

import de.mediathekview.mlib.tool.Log;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimedTextMarkupLanguageParser {
    private final SimpleDateFormat ttmlFormat = new SimpleDateFormat("HH:mm:ss.SS");
    private final SimpleDateFormat srtFormat = new SimpleDateFormat("HH:mm:ss,SS");
    private final SimpleDateFormat sdfFlash = new SimpleDateFormat("s.S");
    private final Map<String, String> colorMap = new Hashtable<String, String>();
    private final List<Subtitle> subtitleList = new ArrayList<Subtitle>();
    private String color = "#FFFFFF";
    private Document doc = null;

    private void buildColorMap() {
        NodeList styleData = this.doc.getElementsByTagName("tt:style");
        for (int i = 0; i < styleData.getLength(); ++i) {
            Node subnode = styleData.item(i);
            if (!subnode.hasAttributes()) continue;
            NamedNodeMap attrMap = subnode.getAttributes();
            Node idNode = attrMap.getNamedItem("xml:id");
            Node colorNode = attrMap.getNamedItem("tts:color");
            if (idNode == null || colorNode == null) continue;
            this.colorMap.put(idNode.getNodeValue(), colorNode.getNodeValue());
        }
    }

    private void buildFilmList() throws Exception {
        NodeList subtitleData = this.doc.getElementsByTagName("tt:p");
        for (int i = 0; i < subtitleData.getLength(); ++i) {
            Subtitle subtitle = new Subtitle();
            Node subnode = subtitleData.item(i);
            if (subnode.hasAttributes()) {
                NamedNodeMap attrMap = subnode.getAttributes();
                Node beginNode = attrMap.getNamedItem("begin");
                Node endNode = attrMap.getNamedItem("end");
                if (beginNode != null && endNode != null) {
                    subtitle.begin = this.ttmlFormat.parse(beginNode.getNodeValue());
                    if (subtitle.begin.getHours() >= 10) {
                        subtitle.begin.setHours(subtitle.begin.getHours() - 10);
                    }
                    subtitle.end = this.ttmlFormat.parse(endNode.getNodeValue());
                    if (subtitle.end.getHours() >= 10) {
                        subtitle.end.setHours(subtitle.end.getHours() - 10);
                    }
                }
            }
            NodeList childNodes = subnode.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node node = childNodes.item(j);
                if (!node.getNodeName().equalsIgnoreCase("tt:span")) continue;
                NamedNodeMap attrMap = node.getAttributes();
                Node styleNode = attrMap.getNamedItem("style");
                StyledString textContent = new StyledString();
                textContent.setText(node.getTextContent());
                String col = this.colorMap.get(styleNode.getNodeValue());
                if (col == null) {
                    textContent.setColor(this.color);
                } else {
                    textContent.setColor(this.colorMap.get(styleNode.getNodeValue()));
                }
                subtitle.listOfStrings.add(textContent);
            }
            this.subtitleList.add(subtitle);
        }
    }

    private Date parseFlash(String tStamp) throws ParseException {
        Date da = tStamp.contains(":") ? this.ttmlFormat.parse(tStamp) : this.sdfFlash.parse(tStamp + "00");
        return da;
    }

    private void buildFilmListFlash() throws Exception {
        NodeList subtitleData = this.doc.getElementsByTagName("p");
        for (int i = 0; i < subtitleData.getLength(); ++i) {
            Subtitle subtitle = new Subtitle();
            Node subnode = subtitleData.item(i);
            if (subnode.hasAttributes()) {
                NamedNodeMap attrMap = subnode.getAttributes();
                Node beginNode = attrMap.getNamedItem("begin");
                Node endNode = attrMap.getNamedItem("end");
                if (beginNode != null && endNode != null) {
                    subtitle.begin = this.parseFlash(beginNode.getNodeValue());
                    subtitle.end = this.parseFlash(endNode.getNodeValue());
                    StyledString textContent = new StyledString();
                    textContent.setColor(this.color);
                    textContent.setText(subnode.getTextContent());
                    Node col = attrMap.getNamedItem("tts:color");
                    if (col != null) {
                        textContent.setColor(col.getNodeValue());
                    } else {
                        NodeList childNodes = subnode.getChildNodes();
                        for (int j = 0; j < childNodes.getLength(); ++j) {
                            Node node = childNodes.item(j);
                            if (!node.getNodeName().equalsIgnoreCase("span")) continue;
                            NamedNodeMap attr = node.getAttributes();
                            Node co = attr.getNamedItem("tts:color");
                            textContent.setColor(co.getNodeValue());
                        }
                    }
                    subtitle.listOfStrings.add(textContent);
                }
            }
            this.subtitleList.add(subtitle);
        }
    }

    public boolean parse(Path ttmlFilePath) {
        boolean ret;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.parse(ttmlFilePath.toFile());
            NodeList metaData = this.doc.getElementsByTagName("ebuttm:documentEbuttVersion");
            if (metaData != null) {
                Node versionNode = metaData.item(0);
                if (versionNode == null || !versionNode.getTextContent().equalsIgnoreCase("v1.0")) {
                    throw new Exception("Unknown TTML file version");
                }
            } else {
                throw new Exception("Unknown File Format");
            }
            this.buildColorMap();
            this.buildFilmList();
            ret = true;
        }
        catch (Exception ex) {
            Log.errorLog(912036478, new String[]{ex.getLocalizedMessage(), "File: " + ttmlFilePath});
            ret = false;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parseXmlFlash(Path ttmlFilePath) {
        try {
            String s;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.parse(ttmlFilePath.toFile());
            NodeList metaData = this.doc.getElementsByTagName("tt");
            NodeList colorNote = this.doc.getElementsByTagName("style");
            if (metaData == null) throw new Exception("Unknown File Format");
            Node node = metaData.item(0);
            if (!node.hasAttributes()) throw new Exception("Unknown File Format");
            NamedNodeMap attrMap = node.getAttributes();
            Node xmlns = attrMap.getNamedItem("xmlns");
            if (xmlns != null && !(s = xmlns.getNodeValue()).equals("http://www.w3.org/2006/04/ttaf1") && !s.equals("http://www.w3.org/ns/ttml")) {
                throw new Exception("Unknown TTML file version");
            }
            if (colorNote == null) throw new Exception("Unknown File Format");
            if (colorNote.getLength() == 0) {
                this.color = "#FFFFFF";
            } else {
                node = colorNote.item(0);
                if (!node.hasAttributes()) throw new Exception("Unknown File Format");
                attrMap = node.getAttributes();
                Node col = attrMap.getNamedItem("tts:color");
                if (col != null && !col.getNodeValue().isEmpty()) {
                    this.color = col.getNodeValue();
                }
            }
            this.buildFilmListFlash();
            return true;
        }
        catch (Exception ex) {
            Log.errorLog(46231470, new String[]{ex.getLocalizedMessage(), "File: " + ttmlFilePath});
            return false;
        }
    }

    public void toSrt(Path srtFile) {
        try (FileOutputStream fos = new FileOutputStream(srtFile.toFile());
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF-8"));
             PrintWriter writer = new PrintWriter(osw);){
            long counter = 1L;
            for (Subtitle title : this.subtitleList) {
                writer.println(counter);
                writer.println(this.srtFormat.format(title.begin) + " --> " + this.srtFormat.format(title.end));
                for (StyledString entry : title.listOfStrings) {
                    if (!entry.color.isEmpty()) {
                        writer.print("<font color=\"" + entry.color + "\">");
                    }
                    writer.print(entry.text);
                    if (!entry.color.isEmpty()) {
                        writer.print("</font>");
                    }
                    writer.println();
                }
                writer.println("");
                ++counter;
            }
        }
        catch (Exception ex) {
            Log.errorLog(201036470, ex, "File: " + srtFile);
        }
    }

    public void cleanup() {
        this.colorMap.clear();
        this.subtitleList.clear();
    }

    private class Subtitle {
        public Date begin;
        public Date end;
        public List<StyledString> listOfStrings = new ArrayList<StyledString>();

        private Subtitle() {
        }
    }

    private class StyledString {
        private String text = "";
        private String color = "";

        private StyledString() {
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }
    }
}

