/*
 * Decompiled with CFR 0.152.
 */
package etm.core.configuration;

import etm.core.aggregation.Aggregator;
import etm.core.aggregation.BufferedThresholdAggregator;
import etm.core.configuration.EtmAggregatorConfig;
import etm.core.configuration.EtmConfigurationException;
import etm.core.configuration.EtmMonitorConfig;
import etm.core.configuration.EtmPluginConfig;
import etm.core.monitor.EtmMonitor;
import etm.core.plugin.EtmPlugin;
import etm.core.timer.DefaultTimer;
import etm.core.timer.ExecutionTimer;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class EtmMonitorFactory {
    private static final LogAdapter log = Log.getLog(class$etm$core$configuration$EtmMonitorFactory == null ? (class$etm$core$configuration$EtmMonitorFactory = EtmMonitorFactory.class$("etm.core.configuration.EtmMonitorFactory")) : class$etm$core$configuration$EtmMonitorFactory);
    private static final String[] jetmTimer = new String[]{"etm.core.timer.Java15NanoTimer", "etm.core.timer.SunHighResTimer", "etm.core.timer.DefaultTimer"};
    static /* synthetic */ Class class$etm$core$configuration$EtmMonitorFactory;
    static /* synthetic */ Class class$etm$core$timer$ExecutionTimer;
    static /* synthetic */ Class class$etm$core$aggregation$Aggregator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$List;

    public static EtmMonitor createEtmMonitor(EtmMonitorConfig monitorConfig) throws Exception {
        Object obj;
        try {
            Constructor constructor = monitorConfig.getMonitorClass().getConstructor(class$etm$core$timer$ExecutionTimer == null ? (class$etm$core$timer$ExecutionTimer = EtmMonitorFactory.class$("etm.core.timer.ExecutionTimer")) : class$etm$core$timer$ExecutionTimer, class$etm$core$aggregation$Aggregator == null ? (class$etm$core$aggregation$Aggregator = EtmMonitorFactory.class$("etm.core.aggregation.Aggregator")) : class$etm$core$aggregation$Aggregator);
            obj = constructor.newInstance(EtmMonitorFactory.createTimer(monitorConfig), EtmMonitorFactory.createAggregators(monitorConfig));
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor constructor = monitorConfig.getMonitorClass().getConstructor(class$etm$core$aggregation$Aggregator == null ? (class$etm$core$aggregation$Aggregator = EtmMonitorFactory.class$("etm.core.aggregation.Aggregator")) : class$etm$core$aggregation$Aggregator);
                obj = constructor.newInstance(EtmMonitorFactory.createAggregators(monitorConfig));
            }
            catch (NoSuchMethodException e1) {
                try {
                    Constructor constructor = monitorConfig.getMonitorClass().getConstructor(class$etm$core$timer$ExecutionTimer == null ? (class$etm$core$timer$ExecutionTimer = EtmMonitorFactory.class$("etm.core.timer.ExecutionTimer")) : class$etm$core$timer$ExecutionTimer);
                    obj = constructor.newInstance(EtmMonitorFactory.createTimer(monitorConfig));
                }
                catch (NoSuchMethodException e2) {
                    obj = monitorConfig.getMonitorClass().newInstance();
                }
            }
        }
        EtmMonitor etmMonitor = (EtmMonitor)obj;
        List pluginConfig = monitorConfig.getPluginConfig();
        if (pluginConfig != null) {
            EtmMonitorFactory.addPlugins(etmMonitor, pluginConfig);
        }
        if (monitorConfig.isAutostart()) {
            etmMonitor.start();
            Runtime.getRuntime().addShutdownHook(new ShutDownHook(etmMonitor));
        }
        return etmMonitor;
    }

    public static ExecutionTimer bestAvailableTimer() {
        for (int i = 0; i < jetmTimer.length; ++i) {
            try {
                return (ExecutionTimer)EtmMonitorFactory.instantiateClass(jetmTimer[i]);
            }
            catch (Exception e) {
                log.warn("Unable to instantiate execution timer '" + jetmTimer[i] + "'. Trying next. Cause:" + e.getMessage());
                continue;
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) continue;
                throw (ThreadDeath)e;
            }
        }
        return new DefaultTimer();
    }

    private static ExecutionTimer createTimer(EtmMonitorConfig monitorConfig) throws IllegalAccessException, InstantiationException {
        if (monitorConfig.getTimerClass() != null) {
            return (ExecutionTimer)monitorConfig.getTimerClass().newInstance();
        }
        return EtmMonitorFactory.bestAvailableTimer();
    }

    private static Aggregator createAggregators(EtmMonitorConfig monitorConfig) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassNotFoundException {
        if (monitorConfig.getAggregatorRoot() != null) {
            List config;
            Aggregator current = (Aggregator)monitorConfig.getAggregatorRoot().getAggregatorClass().newInstance();
            Map properties = monitorConfig.getAggregatorRoot().getProperties();
            if (properties != null) {
                EtmMonitorFactory.setProperties(current, properties);
            }
            if ((config = monitorConfig.getEtmAggregators()) != null) {
                for (int i = config.size() - 1; i >= 0; --i) {
                    EtmAggregatorConfig etmAggregator = (EtmAggregatorConfig)config.get(i);
                    try {
                        Constructor constructor = etmAggregator.getAggregatorClass().getConstructor(class$etm$core$aggregation$Aggregator == null ? EtmMonitorFactory.class$("etm.core.aggregation.Aggregator") : class$etm$core$aggregation$Aggregator);
                        current = (Aggregator)constructor.newInstance(current);
                    }
                    catch (NoSuchMethodException e) {
                        throw new EtmConfigurationException("Nested aggregator does not have an constructor with type Aggregator.");
                    }
                    properties = etmAggregator.getProperties();
                    if (properties == null) continue;
                    EtmMonitorFactory.setProperties(current, properties);
                }
            } else if (!current.getMetaData().isBuffering()) {
                current = new BufferedThresholdAggregator(current);
            }
            return current;
        }
        return null;
    }

    private static void addPlugins(EtmMonitor aEtmMonitor, List aPluginConfig) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassNotFoundException {
        for (int i = 0; i < aPluginConfig.size(); ++i) {
            EtmPluginConfig etmPluginConfig = (EtmPluginConfig)aPluginConfig.get(i);
            Object obj = etmPluginConfig.getPluginClass().newInstance();
            if (etmPluginConfig.getProperties() != null) {
                EtmMonitorFactory.setProperties(obj, etmPluginConfig.getProperties());
            }
            aEtmMonitor.addPlugin((EtmPlugin)obj);
        }
    }

    private static void setProperties(Object obj, Map properties) throws IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String propertyName;
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("set") || methodName.length() < 4 || !properties.containsKey(propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4)) || method.getParameterTypes().length != 1) continue;
            Object value = properties.get(propertyName);
            Class<?> clazz = method.getParameterTypes()[0];
            if (Integer.TYPE.isAssignableFrom(clazz)) {
                method.invoke(obj, new Integer(Integer.parseInt((String)value)));
                continue;
            }
            if (Long.TYPE.isAssignableFrom(clazz)) {
                method.invoke(obj, new Long(Long.parseLong((String)value)));
                continue;
            }
            if (Boolean.TYPE.isAssignableFrom(clazz)) {
                if ("true".equals(value)) {
                    method.invoke(obj, Boolean.TRUE);
                    continue;
                }
                if (!"false".equals(value)) continue;
                method.invoke(obj, Boolean.FALSE);
                continue;
            }
            if ((class$java$lang$String == null ? EtmMonitorFactory.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(clazz)) {
                method.invoke(obj, value);
                continue;
            }
            if ((class$java$lang$Class == null ? EtmMonitorFactory.class$("java.lang.Class") : class$java$lang$Class).isAssignableFrom(clazz)) {
                method.invoke(obj, Class.forName((String)value));
                continue;
            }
            if ((class$java$util$Map == null ? EtmMonitorFactory.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(clazz)) {
                if (!(value instanceof Map)) continue;
                method.invoke(obj, value);
                continue;
            }
            if (!(class$java$util$List == null ? EtmMonitorFactory.class$("java.util.List") : class$java$util$List).isAssignableFrom(clazz) || !(value instanceof List)) continue;
            method.invoke(obj, value);
        }
    }

    private static Object instantiateClass(String className) throws Exception {
        Class<?> clazz = Class.forName(className);
        return clazz.newInstance();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ShutDownHook
    extends Thread {
        private final EtmMonitor etmMonitor;

        public ShutDownHook(EtmMonitor aEtmMonitor) {
            this.etmMonitor = aEtmMonitor;
        }

        public void run() {
            if (this.etmMonitor.isStarted()) {
                this.etmMonitor.stop();
            }
        }
    }
}

