/*
 * Decompiled with CFR 0.152.
 */
package etm.core.configuration;

import etm.core.configuration.EtmAggregatorConfig;
import etm.core.configuration.EtmConfigurationException;
import etm.core.configuration.EtmMonitorConfig;
import etm.core.configuration.EtmPluginConfig;
import etm.core.configuration.XmlConfigParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Xml10ConfigParser
extends XmlConfigParser {
    Xml10ConfigParser() {
    }

    public EtmMonitorConfig parse(Document aDocument) {
        NodeList extension;
        Node node;
        NodeList monitorTypes;
        EtmMonitorConfig monitorConfig = new EtmMonitorConfig();
        Element documentElement = aDocument.getDocumentElement();
        String attribute = this.getAttribute(documentElement, "autostart");
        if ("true".equals(attribute)) {
            monitorConfig.setAutostart(true);
        }
        if ((monitorTypes = documentElement.getElementsByTagName("monitor-type")).getLength() != 0) {
            Node node2 = monitorTypes.item(0);
            monitorConfig.setMonitorType(this.getNodeFirstChildTextValue(node2));
        } else {
            NodeList monitorClasses = documentElement.getElementsByTagName("monitor-class");
            if (monitorClasses.getLength() != 0) {
                node = monitorClasses.item(0);
                monitorConfig.setMonitorType(this.getNodeFirstChildTextValue(node));
            }
        }
        NodeList timerTypes = documentElement.getElementsByTagName("timer-type");
        if (timerTypes.getLength() != 0) {
            node = timerTypes.item(0);
            monitorConfig.setTimerType(this.getNodeFirstChildTextValue(node));
        } else {
            NodeList timerClasses = documentElement.getElementsByTagName("timer-class");
            if (timerClasses.getLength() != 0) {
                Node node3 = timerClasses.item(0);
                monitorConfig.setTimerType(this.getNodeFirstChildTextValue(node3));
            }
        }
        NodeList aggregatorChain = documentElement.getElementsByTagName("aggregator-chain");
        if (aggregatorChain.getLength() != 0) {
            Element element = (Element)aggregatorChain.item(0);
            NodeList aggregatorRoot = element.getElementsByTagName("chain-root");
            if (aggregatorRoot.getLength() == 0) {
                throw new EtmConfigurationException("At least one aggregator-root element has to be specified");
            }
            EtmAggregatorConfig rootConfig = this.extractAggregatorConfig((Element)aggregatorRoot.item(0));
            monitorConfig.setAggregatorRoot(rootConfig);
            NodeList aggregators = element.getElementsByTagName("chain-element");
            for (int i = 0; i < aggregators.getLength(); ++i) {
                Element aggregator = (Element)aggregators.item(i);
                EtmAggregatorConfig aggregatorConfig = this.extractAggregatorConfig(aggregator);
                monitorConfig.appendAggregator(aggregatorConfig);
            }
        }
        if ((extension = documentElement.getElementsByTagName("extension")).getLength() != 0) {
            NodeList plugins = ((Element)extension.item(0)).getElementsByTagName("plugin");
            for (int i = 0; i < plugins.getLength(); ++i) {
                Element plugin = (Element)plugins.item(i);
                EtmPluginConfig pluginConfig = this.extractPluginConfig(plugin);
                monitorConfig.addExtension(pluginConfig);
            }
        }
        return monitorConfig;
    }

    protected EtmPluginConfig extractPluginConfig(Element aPlugin) {
        EtmPluginConfig pluginConfig = new EtmPluginConfig();
        NodeList pluginClasses = aPlugin.getElementsByTagName("plugin-class");
        if (pluginClasses.getLength() == 0) {
            throw new EtmConfigurationException("No valid plugin class found");
        }
        Node node = pluginClasses.item(0);
        pluginConfig.setPluginClass(this.getNodeFirstChildTextValue(node));
        NodeList properties = aPlugin.getElementsByTagName("property");
        for (int j = 0; j < properties.getLength(); ++j) {
            Element property = (Element)properties.item(j);
            pluginConfig.addProperty(this.getAttribute(property, "name"), this.getNodeFirstChildTextValue(property));
        }
        return pluginConfig;
    }

    protected EtmAggregatorConfig extractAggregatorConfig(Element aAggregator) {
        EtmAggregatorConfig aggregatorConfig = new EtmAggregatorConfig();
        NodeList aggregatorClasses = aAggregator.getElementsByTagName("aggregator-class");
        if (aggregatorClasses.getLength() == 0) {
            throw new EtmConfigurationException("No valid aggregator class found");
        }
        Node node = aggregatorClasses.item(0);
        aggregatorConfig.setAggregatorClass(this.getNodeFirstChildTextValue(node));
        NodeList properties = aAggregator.getElementsByTagName("property");
        for (int j = 0; j < properties.getLength(); ++j) {
            Element property = (Element)properties.item(j);
            aggregatorConfig.addProperty(this.getAttribute(property, "name"), this.getNodeFirstChildTextValue(property));
        }
        return aggregatorConfig;
    }
}

