/*
 * Decompiled with CFR 0.152.
 */
package etm.core.util.collection;

import etm.core.util.collection.EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.Map;

public abstract class CollectionFactory {
    private static CollectionFactory collectionFactory;

    public abstract Map newConcurrentHashMapInstance();

    public static CollectionFactory getInstance() {
        if (collectionFactory == null) {
            try {
                Class<?> clazz = Class.forName("etm.core.util.collection.Java50CollectionFactory");
                collectionFactory = (CollectionFactory)clazz.newInstance();
            }
            catch (Throwable e) {
                collectionFactory = new DefaultCollectionFactory();
            }
        }
        return collectionFactory;
    }

    static class DefaultCollectionFactory
    extends CollectionFactory {
        DefaultCollectionFactory() {
        }

        public Map newConcurrentHashMapInstance() {
            return new ConcurrentReaderHashMap();
        }
    }
}

