/*
 * Decompiled with CFR 0.152.
 */
package etm.core.aggregation;

import etm.core.aggregation.Aggregator;
import etm.core.metadata.AggregatorMetaData;
import etm.core.monitor.EtmMonitorContext;
import etm.core.monitor.EtmPoint;
import etm.core.renderer.MeasurementRenderer;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.util.TimerTask;

public class BufferedTimedAggregator
implements Aggregator {
    private static final LogAdapter log = Log.getLog(class$etm$core$aggregation$BufferedTimedAggregator == null ? (class$etm$core$aggregation$BufferedTimedAggregator = BufferedTimedAggregator.class$("etm.core.aggregation.BufferedTimedAggregator")) : class$etm$core$aggregation$BufferedTimedAggregator);
    private static final String DESCRIPTION_PREFIX = "A time based buffering aggregator with a flush interval of ";
    private static final String DESCRIPTION_POSTFIX = " ms.";
    private static final long DEFAULT_AGGREGATION_INTERVAL = 5000L;
    private static final int DEFAULT_BUFFER_SIZE = 25000;
    private static final int MIN_AGGREGATION_INTERVAL = 10;
    protected final Aggregator delegate;
    protected UnboundedBuffer buffer;
    private long sleepInterval;
    private int initialBufferSize = 25000;
    private EtmMonitorContext ctx;
    private boolean started = false;
    static /* synthetic */ Class class$etm$core$aggregation$BufferedTimedAggregator;

    public BufferedTimedAggregator(Aggregator aAggregator) {
        this.delegate = aAggregator;
        this.setAggregationInterval(5000L);
    }

    public void add(EtmPoint point) {
        if (!this.started) {
            return;
        }
        this.buffer.add(point);
    }

    public void flush() {
        this.buffer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Aggregator aggregator = this.delegate;
        synchronized (aggregator) {
            this.delegate.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(String symbolicName) {
        Aggregator aggregator = this.delegate;
        synchronized (aggregator) {
            this.delegate.reset(symbolicName);
        }
    }

    public void render(MeasurementRenderer renderer) {
        this.flush();
        this.delegate.render(renderer);
    }

    public void init(EtmMonitorContext aCtx) {
        this.ctx = aCtx;
        this.delegate.init(aCtx);
    }

    public void start() {
        this.delegate.start();
        this.buffer = new UnboundedBuffer(this.initialBufferSize);
        this.ctx.getScheduler().scheduleAtFixedRate(new TimerTask(){

            public void run() {
                try {
                    BufferedTimedAggregator.this.buffer.flush();
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        BufferedTimedAggregator.this.started = false;
                        this.cancel();
                        log.warn("Error occured in BufferedTimedAggregator. Disable collection to prevent memory leak.");
                        throw (ThreadDeath)t;
                    }
                    if (t instanceof Error) {
                        BufferedTimedAggregator.this.started = false;
                        this.cancel();
                        log.warn("Error occured in BufferedTimedAggregator. Disable collection to prevent memory leak.");
                        throw (Error)t;
                    }
                    log.fatal("Error in aggregation buffer.", t);
                }
            }
        }, this.sleepInterval, this.sleepInterval);
        this.started = true;
    }

    public void stop() {
        this.started = false;
        this.flush();
        this.delegate.stop();
    }

    public AggregatorMetaData getMetaData() {
        return new AggregatorMetaData(class$etm$core$aggregation$BufferedTimedAggregator == null ? (class$etm$core$aggregation$BufferedTimedAggregator = BufferedTimedAggregator.class$("etm.core.aggregation.BufferedTimedAggregator")) : class$etm$core$aggregation$BufferedTimedAggregator, DESCRIPTION_PREFIX + this.sleepInterval + DESCRIPTION_POSTFIX, true, this.delegate.getMetaData());
    }

    public void setAggregationInterval(long aAggregationInterval) {
        if (aAggregationInterval < 10L) {
            throw new IllegalArgumentException("Aggregation intervals lower than 10 miliseconds not supported.");
        }
        this.sleepInterval = aAggregationInterval;
    }

    public void setInitialBufferSize(int aInitialBufferSize) {
        if (aInitialBufferSize < 1000) {
            throw new IllegalArgumentException("The initial buffer size may not be smaller than 1000.");
        }
        this.initialBufferSize = aInitialBufferSize;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class UnboundedBuffer {
        private EtmPoint[] buffer;
        private int currentPos = 0;
        private static final double NEWSIZE_MULTIPLIER = 1.5;

        public UnboundedBuffer(int size) {
            this.buffer = new EtmPoint[size];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(EtmPoint point) {
            UnboundedBuffer unboundedBuffer = this;
            synchronized (unboundedBuffer) {
                this.buffer[this.currentPos] = point;
                ++this.currentPos;
                if (this.currentPos == this.buffer.length) {
                    EtmPoint[] newBuffer = new EtmPoint[(int)((double)this.currentPos * 1.5)];
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.currentPos);
                    this.buffer = newBuffer;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            EtmPoint[] current;
            int length;
            Object object = this;
            synchronized (object) {
                length = this.currentPos;
                current = this.buffer;
                this.buffer = new EtmPoint[current.length];
                this.currentPos = 0;
            }
            object = BufferedTimedAggregator.this.delegate;
            synchronized (object) {
                for (int i = 0; i < length; ++i) {
                    BufferedTimedAggregator.this.delegate.add(current[i]);
                }
            }
        }
    }
}

