/*
 * Decompiled with CFR 0.152.
 */
package etm.core.aggregation;

import etm.core.aggregation.Aggregator;
import etm.core.aggregation.ExecutionAggregate;
import etm.core.metadata.AggregatorMetaData;
import etm.core.monitor.EtmMonitorContext;
import etm.core.monitor.EtmPoint;
import etm.core.monitor.event.MonitorResetEvent;
import etm.core.monitor.event.RootCreateEvent;
import etm.core.monitor.event.RootResetEvent;
import etm.core.renderer.MeasurementRenderer;
import etm.core.util.collection.CollectionFactory;
import java.util.Map;

public class FlatAggregator
implements Aggregator {
    protected Map aggregates = CollectionFactory.getInstance().newConcurrentHashMapInstance();
    protected EtmMonitorContext ctx;
    static /* synthetic */ Class class$etm$core$aggregation$FlatAggregator;

    public void reset() {
        this.aggregates.clear();
        this.ctx.fireEvent(new MonitorResetEvent(this));
    }

    public void reset(String symbolicName) {
        ExecutionAggregate aggregate = (ExecutionAggregate)this.aggregates.get(symbolicName);
        if (aggregate != null) {
            aggregate.reset();
            this.ctx.fireEvent(new RootResetEvent(symbolicName, this));
        }
    }

    public void render(MeasurementRenderer renderer) {
        renderer.render(this.aggregates);
    }

    public void add(EtmPoint point) {
        ExecutionAggregate aggregate = this.getAggregate(point.getName());
        aggregate.addTransaction(point);
    }

    public void flush() {
    }

    public AggregatorMetaData getMetaData() {
        return new AggregatorMetaData(class$etm$core$aggregation$FlatAggregator == null ? (class$etm$core$aggregation$FlatAggregator = FlatAggregator.class$("etm.core.aggregation.FlatAggregator")) : class$etm$core$aggregation$FlatAggregator, "An cummulating aggregator for flat representation.", false);
    }

    public void start() {
    }

    public void stop() {
    }

    public void init(EtmMonitorContext aCtx) {
        this.ctx = aCtx;
    }

    protected ExecutionAggregate getAggregate(String aName) {
        ExecutionAggregate aggregate = (ExecutionAggregate)this.aggregates.get(aName);
        if (aggregate == null) {
            aggregate = new ExecutionAggregate(aName);
            this.aggregates.put(aName, aggregate);
            this.ctx.fireEvent(new RootCreateEvent(aggregate, this));
        }
        return aggregate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

