/*
 * Decompiled with CFR 0.152.
 */
package etm.core.aggregation.persistence;

import etm.core.aggregation.persistence.PersistenceBackend;
import etm.core.aggregation.persistence.PersistentEtmState;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class FileSystemPersistenceBackend
implements PersistenceBackend {
    private static final LogAdapter log = Log.getLog(class$etm$core$aggregation$persistence$FileSystemPersistenceBackend == null ? (class$etm$core$aggregation$persistence$FileSystemPersistenceBackend = FileSystemPersistenceBackend.class$("etm.core.aggregation.persistence.FileSystemPersistenceBackend")) : class$etm$core$aggregation$persistence$FileSystemPersistenceBackend);
    private File path = new File(System.getProperty("java.io.tmpdir"));
    private String filename = "jetm-state.ser";
    static /* synthetic */ Class class$etm$core$aggregation$persistence$FileSystemPersistenceBackend;

    public void setPath(String aPath) {
        this.path = new File(aPath);
    }

    public void setFilename(String aFilename) {
        this.filename = aFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentEtmState load() {
        PersistentEtmState state = null;
        File file = new File(this.path, this.filename);
        if (file.exists() && file.canRead()) {
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new FileInputStream(file));
                state = (PersistentEtmState)in.readObject();
            }
            catch (Exception e) {
                log.warn("Error loading state from file " + file.getAbsolutePath(), e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(PersistentEtmState state) {
        File dest;
        if (!this.path.exists()) {
            this.path.mkdirs();
        }
        if ((dest = new File(this.path, this.filename)).exists()) {
            this.backupFile(dest);
            dest.delete();
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(dest));
            out.writeObject(state);
        }
        catch (Exception e) {
            log.warn("Error writing state to file " + dest.getAbsolutePath(), e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupFile(File aDest) {
        File backup = new File(aDest.getAbsolutePath() + ".saved");
        ObjectInputStream in = null;
        ObjectOutputStream out = null;
        try {
            in = new ObjectInputStream(new FileInputStream(aDest));
            out = new ObjectOutputStream(new FileOutputStream(backup));
            out.writeObject(in.readObject());
        }
        catch (Exception e) {
            log.warn("Error writing backup file " + aDest.getAbsolutePath(), e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

