/*
 * Decompiled with CFR 0.152.
 */
package etm.core.jmx;

import etm.core.aggregation.Aggregate;
import etm.core.monitor.EtmException;
import etm.core.monitor.EtmMonitor;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.SimpleType;

public class EtmPointMBean
implements DynamicMBean {
    private EtmMonitor etmMonitor;
    private Aggregate aggregate;
    static /* synthetic */ Class class$etm$core$aggregation$Aggregate;

    public EtmPointMBean(EtmMonitor aEtmMonitor, Aggregate aAggregate) {
        this.etmMonitor = aEtmMonitor;
        this.aggregate = aAggregate;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if ("measurements".equals(string)) {
            return new Long(this.aggregate.getMeasurements());
        }
        if ("total".equals(string)) {
            return new Double(this.aggregate.getTotal());
        }
        if ("min".equals(string)) {
            return new Double(this.aggregate.getMin());
        }
        if ("max".equals(string)) {
            return new Double(this.aggregate.getMax());
        }
        if ("average".equals(string)) {
            return new Double(this.aggregate.getAverage());
        }
        throw new AttributeNotFoundException(string);
    }

    public void setAttribute(Attribute aAttribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException(aAttribute.getName());
    }

    public AttributeList getAttributes(String[] strings) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < strings.length; ++i) {
            try {
                list.add(i, new Attribute(strings[i], this.getAttribute(strings[i])));
                continue;
            }
            catch (Exception e) {
                list.add(i, new Attribute(strings[i], null));
            }
        }
        return list;
    }

    public AttributeList setAttributes(AttributeList aAttributeList) {
        return new AttributeList();
    }

    public Object invoke(String string, Object[] aObjects, String[] aStrings) throws MBeanException, ReflectionException {
        if ("reset".equals(string)) {
            this.etmMonitor.reset(this.aggregate.getName());
        }
        return null;
    }

    public MBeanInfo getMBeanInfo() {
        return new OpenMBeanInfoSupport((class$etm$core$aggregation$Aggregate == null ? (class$etm$core$aggregation$Aggregate = EtmPointMBean.class$("etm.core.aggregation.Aggregate")) : class$etm$core$aggregation$Aggregate).getName(), "Performance results for " + this.aggregate.getName(), this.getAttributeInfos(), new OpenMBeanConstructorInfo[0], this.getOperations(), new MBeanNotificationInfo[0]);
    }

    private OpenMBeanOperationInfo[] getOperations() {
        try {
            return new OpenMBeanOperationInfo[]{new OpenMBeanOperationInfoSupport("reset", "Resets etm point.", null, SimpleType.VOID, 1)};
        }
        catch (Exception e) {
            throw new EtmException(e.getMessage());
        }
    }

    private OpenMBeanAttributeInfo[] getAttributeInfos() {
        try {
            return new OpenMBeanAttributeInfo[]{new OpenMBeanAttributeInfoSupport("measurements", "The number of measurements.", SimpleType.LONG, true, false, false), new OpenMBeanAttributeInfoSupport("average", "The average time in miliseconds.", SimpleType.DOUBLE, true, false, false), new OpenMBeanAttributeInfoSupport("min", "The minimum time in miliseconds..", SimpleType.DOUBLE, true, false, false), new OpenMBeanAttributeInfoSupport("max", "The maximum time in miliseconds.", SimpleType.DOUBLE, true, false, false), new OpenMBeanAttributeInfoSupport("total", "The total time in miliseconds.", SimpleType.DOUBLE, true, false, false)};
        }
        catch (Exception e) {
            throw new EtmException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

