/*
 * Decompiled with CFR 0.152.
 */
package etm.core.monitor;

import etm.core.aggregation.Aggregator;
import etm.core.monitor.EtmMonitorSupport;
import etm.core.monitor.EtmPoint;
import etm.core.monitor.MeasurementPoint;
import etm.core.timer.ExecutionTimer;

public class NestedMonitor
extends EtmMonitorSupport {
    private static final String DESCRIPTION = "A monitor recording nested executions as a tree.";
    private ThreadLocal currentParent = new ThreadLocal();

    public NestedMonitor() {
        this(null, null);
    }

    public NestedMonitor(ExecutionTimer aTimer) {
        this(aTimer, null);
    }

    public NestedMonitor(Aggregator aAggregator) {
        this(null, aAggregator);
    }

    public NestedMonitor(ExecutionTimer aTimer, Aggregator aAggregator) {
        super(DESCRIPTION, aTimer, aAggregator);
    }

    protected void doVisitPreMeasurement(MeasurementPoint measurementPoint) {
        MeasurementPoint point = (MeasurementPoint)this.currentParent.get();
        this.currentParent.set(measurementPoint);
        measurementPoint.setParent(point);
    }

    protected void doVisitPostCollect(MeasurementPoint aPoint) {
        EtmPoint point = (EtmPoint)this.currentParent.get();
        if (point != null) {
            this.currentParent.set(point.getParent());
        }
    }

    public String toString() {
        return "etm.core.monitor.NestedMonitor{ timer=<" + this.timer + ">, aggregator=<" + this.aggregator + "> }";
    }
}

