/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Functions;
import de.mediathekview.mlib.tool.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import mServer.crawler.CrawlerConfig;
import org.apache.commons.lang3.StringUtils;

public class CrawlerTool {
    public static final String nameOrgFilmlist_xz = "filme-org.xz";
    public static final String nameDiffFilmlist = "filme-diff.json";
    public static final String nameAktFilmlist = "filme.json";
    public static final String nameDiffFilmlist_xz = "filme-diff.xz";
    public static final String nameOrgFilmlist = "filme-org.json";
    public static final String nameAktFilmlist_xz = "filme.xz";

    public static synchronized void startMsg() {
        Log.startZeit.setTime(System.currentTimeMillis());
        Log.versionMsg("MSearch");
        Log.sysLog("################################################################################");
        Log.sysLog("");
        Log.sysLog("Programmpfad: " + Functions.getPathJar());
        Log.sysLog("Filmliste: " + CrawlerTool.getPathFilmlist_json_akt(true));
        Log.sysLog("Useragent: " + Config.getUserAgent());
        Log.sysLog("");
        Log.sysLog("################################################################################");
        Log.sysLog("");
        if (CrawlerTool.loadLongMax()) {
            Log.sysLog("Laden:  alles");
        } else {
            Log.sysLog("Laden:  nur update");
        }
        if (CrawlerConfig.updateFilmliste) {
            Log.sysLog("Filmliste:  nur updaten");
        } else {
            Log.sysLog("Filmliste:  neu erstellen");
        }
        Log.sysLog("ImportURL 1:  " + CrawlerConfig.importUrl_1__anhaengen);
        Log.sysLog("ImportURL 2:  " + CrawlerConfig.importUrl_2__anhaengen);
        Log.sysLog("ImportOLD:  " + CrawlerConfig.importOld);
        Log.sysLog("ImportAkt:  " + CrawlerConfig.importAkt);
        if (CrawlerConfig.nurSenderLaden != null) {
            Log.sysLog("Nur Sender laden:  " + StringUtils.join((Object[])CrawlerConfig.nurSenderLaden, (char)','));
        }
        Log.sysLog("");
        Log.sysLog("################################################################################");
    }

    public static boolean loadShort() {
        return CrawlerConfig.senderLoadHow == 0;
    }

    public static boolean loadLong() {
        return CrawlerConfig.senderLoadHow == 1;
    }

    public static boolean loadMax() {
        return CrawlerConfig.senderLoadHow == 2;
    }

    public static boolean loadLongMax() {
        return CrawlerConfig.senderLoadHow >= 1;
    }

    public static String getPathFilmlist_json_org_xz() {
        return Functions.addsPfad(CrawlerConfig.dirFilme, nameOrgFilmlist_xz);
    }

    public static String getPathFilmlist_json_diff_xz() {
        return Functions.addsPfad(CrawlerConfig.dirFilme, nameDiffFilmlist_xz);
    }

    public static String getPathFilmlist_json_diff() {
        return Functions.addsPfad(CrawlerConfig.dirFilme, nameDiffFilmlist);
    }

    public static String getPathFilmlist_json_akt_xz() {
        return Functions.addsPfad(CrawlerConfig.dirFilme, nameAktFilmlist_xz);
    }

    public static String getPathFilmlist_json_org() {
        return Functions.addsPfad(CrawlerConfig.dirFilme, nameOrgFilmlist);
    }

    public static String getPathFilmlist_json_akt(boolean aktDate) {
        if (aktDate) {
            return Functions.addsPfad(CrawlerConfig.dirFilme, new SimpleDateFormat("yyyy.MM.dd__HH.mm.ss").format(new Date()) + "__" + nameAktFilmlist);
        }
        return Functions.addsPfad(CrawlerConfig.dirFilme, nameAktFilmlist);
    }

    public static void addUrlHd(DatenFilm film, String url, String urlRtmp) {
        film.arr[22] = url.isEmpty() ? "" : CrawlerTool.getKlein(film.arr[14], url);
        film.arr[23] = urlRtmp.isEmpty() ? "" : CrawlerTool.getKlein(film.arr[18], urlRtmp);
    }

    public static void addUrlSubtitle(DatenFilm film, String url) {
        film.arr[17] = url;
    }

    public static void addUrlKlein(DatenFilm film, String url, String urlRtmp) {
        film.arr[20] = url.isEmpty() ? "" : CrawlerTool.getKlein(film.arr[14], url);
        film.arr[21] = urlRtmp.isEmpty() ? "" : CrawlerTool.getKlein(film.arr[18], urlRtmp);
    }

    private static String getKlein(String url1, String url2) {
        String ret = "";
        boolean diff = false;
        for (int i = 0; i < url2.length(); ++i) {
            if (url1.length() > i) {
                if (url1.charAt(i) != url2.charAt(i)) {
                    if (!diff) {
                        ret = i + "|";
                    }
                    diff = true;
                }
            } else {
                diff = true;
            }
            if (!diff) continue;
            ret = ret + url2.charAt(i);
        }
        return ret;
    }
}

