/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.br;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.br.BrAllSendungenTask;
import mServer.crawler.sender.br.BrMissedSendungsFolgenTask;
import mServer.crawler.sender.br.BrSendungDetailsTask;

public class BrCrawler
extends MediathekReader {
    public static final String SENDERNAME = "BR";
    public static final String BASE_URL = "https://www.br.de/mediathek/";
    private final ForkJoinPool forkJoinPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors() * 4);

    public BrCrawler(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 0, 100, startPrio);
    }

    @Override
    protected void addToList() {
        this.meldungStart();
        try {
            RecursiveTask<Set<DatenFilm>> filmTask = this.createCrawlerTask();
            Set<DatenFilm> films = this.forkJoinPool.invoke(filmTask);
            Log.sysLog("BR Filme einsortieren...");
            films.forEach(film -> {
                if (!Config.getStop()) {
                    this.addFilm((DatenFilm)film);
                }
            });
            Log.sysLog("BR Film einsortieren fertig");
        }
        catch (Exception e) {
            Log.errorLog(516516521, e);
        }
        finally {
            this.shutdownAndAwaitTermination(this.forkJoinPool, 60L, TimeUnit.SECONDS);
        }
        Log.sysLog("BR fertig");
        this.meldungThreadUndFertig();
    }

    void shutdownAndAwaitTermination(ExecutorService pool, long delay, TimeUnit delayUnit) {
        Log.sysLog("BR: shutdown pool...");
        try {
            try {
                pool.shutdown();
                if (!pool.awaitTermination(delay, delayUnit)) {
                    pool.shutdownNow();
                    if (!pool.awaitTermination(delay, delayUnit)) {
                        Log.sysLog("BR: Pool nicht beendet");
                    }
                }
            }
            catch (InterruptedException ie) {
                Log.errorLog(974513454, ie);
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        catch (Exception e) {
            Log.errorLog(974513455, e);
        }
    }

    private RecursiveTask<Set<String>> createAllSendungenOverviewCrawler() {
        return new BrAllSendungenTask(this, this.forkJoinPool);
    }

    private Callable<Set<String>> createMissedFilmsCrawler() {
        int maximumDays = CrawlerTool.loadLongMax() ? 21 : 7;
        return new BrMissedSendungsFolgenTask(this, maximumDays);
    }

    protected RecursiveTask<Set<DatenFilm>> createCrawlerTask() {
        Callable<Set<String>> missedFilmsTask = this.createMissedFilmsCrawler();
        RecursiveTask<Set<String>> sendungenFilmsTask = this.createAllSendungenOverviewCrawler();
        Future missedFilmIds = this.forkJoinPool.submit(missedFilmsTask);
        this.forkJoinPool.execute(sendungenFilmsTask);
        ConcurrentLinkedQueue<String> brFilmIds = new ConcurrentLinkedQueue<String>();
        try {
            brFilmIds.addAll((Collection)missedFilmIds.get());
            Log.sysLog("BR Anzahl verpasste Sendungen: " + ((Set)missedFilmIds.get()).size());
        }
        catch (Exception exception) {
            Log.errorLog(782346382, exception);
        }
        try {
            brFilmIds.addAll((Collection)sendungenFilmsTask.join());
            Log.sysLog("BR Anzahl: " + ((Set)sendungenFilmsTask.join()).size());
        }
        catch (Exception exception) {
            Log.errorLog(782346383, exception);
        }
        int max = brFilmIds.size() / 50 + 1;
        this.meldungAddMax(max);
        return new BrSendungDetailsTask(this, brFilmIds);
    }
}

