/*
 * Decompiled with CFR 0.152.
 */
package mServer.tool;

import de.mediathekview.mlib.tool.Functions;
import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmPoint;
import java.io.File;
import mServer.daten.MserverListeSuchen;
import mServer.daten.MserverListeUpload;
import mServer.tool.MserverDatumZeit;
import mServer.tool.MserverKonstanten;
import mServer.tool.MserverLog;

public class MserverDaten {
    private static final EtmMonitor etmMonitor = EtmManager.getEtmMonitor();
    public static String[] system = new String[MserverKonstanten.SYSTEM_MAX_ELEM];
    public static MserverListeSuchen listeSuchen = new MserverListeSuchen();
    public static MserverListeUpload listeUpload = new MserverListeUpload();
    public static boolean debug = false;
    public static boolean restart = false;
    private static String basisverzeichnis = "";

    public static void init() {
        EtmPoint performancePoint = etmMonitor.createPoint("MserverDaten:init");
        listeSuchen = new MserverListeSuchen();
        listeUpload = new MserverListeUpload();
        debug = false;
        restart = false;
        for (int i = 0; i < system.length; ++i) {
            MserverDaten.system[i] = "";
        }
        performancePoint.collect();
    }

    public static String getUserAgent() {
        if (system[0].trim().equals("")) {
            return "MServer 3 / " + Functions.getProgVersion().toString();
        }
        return system[0].trim();
    }

    public static void setBasisVerzeichnis(String b) {
        basisverzeichnis = b.isEmpty() ? MserverDaten.getBasisVerzeichnis(b, true) : b;
    }

    public static int getProxyPort() {
        if (system[12].isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseInt(system[12]);
        }
        catch (Exception ex) {
            MserverLog.fehlerMeldung(963487219, MserverDaten.class.getName(), new String[]{"Proxyport falsch: ", system[12]});
            return -1;
        }
    }

    public static String getBasisVerzeichnis() {
        return MserverDaten.getBasisVerzeichnis(basisverzeichnis, false);
    }

    private static String getBasisVerzeichnis(String basis, boolean anlegen) {
        File basisF;
        String ret = basis.isEmpty() ? System.getProperty("user.home") + File.separator + ".mserver" + File.separator : basis;
        if (anlegen && !(basisF = new File(ret)).exists() && !basisF.mkdirs()) {
            MserverLog.fehlerMeldung(1023974998, MserverDaten.class.getName(), new String[]{"Kann den Ordner zum Speichern der Daten nicht anlegen!", ret});
        }
        return ret;
    }

    public static String getKonfigDatei() {
        return MserverDaten.getBasisVerzeichnis() + "mserver.xml";
    }

    public static String getUploadDatei() {
        return MserverDaten.getBasisVerzeichnis() + "upload.xml";
    }

    public static boolean konfigExistiert() {
        String datei = MserverDaten.getBasisVerzeichnis() + "mserver.xml";
        return new File(datei).exists();
    }

    public static String getVerzeichnisFilme() {
        String ret = Functions.addsPfad(MserverDaten.getBasisVerzeichnis(basisverzeichnis, false), "filmlisten");
        File basisF = new File(ret);
        if (!basisF.exists() && !basisF.mkdirs()) {
            MserverLog.fehlerMeldung(739851049, MserverDaten.class.getName(), new String[]{"Kann den Ordner zum Speichern der Filmliste nicht anlegen!", ret});
        }
        return ret;
    }

    public static String getLogDatei(String name) {
        String logFileName;
        String logPfad = "";
        try {
            logPfad = Functions.addsPfad(MserverDaten.getBasisVerzeichnis(basisverzeichnis, false), "log");
            logFileName = Functions.addsPfad(logPfad, name + "__" + MserverDatumZeit.getHeute_yyyy_MM_dd() + ".log");
            File logfile = new File(logFileName);
            if (!logfile.exists()) {
                new File(logPfad).mkdirs();
                if (!logfile.createNewFile()) {
                    logFileName = "";
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Logfile anlegen: " + name + '\n' + ex.getMessage());
            logFileName = "";
        }
        if (logFileName.isEmpty()) {
            MserverLog.fehlerMeldung(912304578, MserverDaten.class.getName(), new String[]{"Kann das Logfile nicht anlegen!", logPfad, logFileName});
        }
        return logFileName;
    }
}

