/*
 * Decompiled with CFR 0.152.
 */
package etm.core.aggregation.persistence;

import etm.core.aggregation.RootAggregator;
import etm.core.aggregation.persistence.FileSystemPersistenceBackend;
import etm.core.aggregation.persistence.PersistenceBackend;
import etm.core.aggregation.persistence.PersistentEtmState;
import etm.core.metadata.AggregatorMetaData;
import etm.core.monitor.EtmMonitorContext;
import etm.core.monitor.event.AggregationStateLoadedEvent;
import etm.core.util.PropertySupport;
import java.util.Map;

public class PersistentRootAggregator
extends RootAggregator {
    protected EtmMonitorContext context;
    protected PersistenceBackend persistenceBackend;
    protected Map backendProperties;
    static /* synthetic */ Class class$etm$core$aggregation$persistence$PersistentRootAggregator;

    public void init(EtmMonitorContext ctx) {
        super.init(ctx);
        this.context = ctx;
        if (this.persistenceBackend == null) {
            this.persistenceBackend = new FileSystemPersistenceBackend();
        }
        if (this.backendProperties != null) {
            PropertySupport.setProperties(this.persistenceBackend, this.backendProperties);
        }
    }

    public void start() {
        super.start();
        PersistentEtmState state = this.persistenceBackend.load();
        if (state != null) {
            this.aggregates = state.getAggregates();
            this.context.fireEvent(new AggregationStateLoadedEvent(state, this));
        }
    }

    public void stop() {
        PersistentEtmState state = new PersistentEtmState();
        state.setStartTime(this.context.getEtmMonitor().getMetaData().getStartTime());
        state.setLastResetTime(this.context.getEtmMonitor().getMetaData().getLastResetTime());
        state.setAggregates(this.aggregates);
        this.persistenceBackend.store(state);
        super.stop();
    }

    public void setPersistenceBackend(PersistenceBackend aPersistenceBackend) {
        if (this.persistenceBackend != null) {
            throw new IllegalStateException("Persistence backend already set. Please use setPersistenceBackend or setPersistenceBackendClass");
        }
        this.persistenceBackend = aPersistenceBackend;
    }

    public void setBackendProperties(Map someProperties) {
        this.backendProperties = someProperties;
    }

    public void setPersistenceBackendClass(Class aPersistenceBackendClazz) {
        if (this.persistenceBackend != null) {
            throw new IllegalStateException("Persistence backend already set. Please use setPersistenceBackend or setPersistenceBackendClass");
        }
        try {
            this.persistenceBackend = (PersistenceBackend)aPersistenceBackendClazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error instantiating persistence class " + aPersistenceBackendClazz + ":" + e.getMessage());
        }
    }

    public AggregatorMetaData getMetaData() {
        return new AggregatorMetaData(class$etm$core$aggregation$persistence$PersistentRootAggregator == null ? (class$etm$core$aggregation$persistence$PersistentRootAggregator = PersistentRootAggregator.class$("etm.core.aggregation.persistence.PersistentRootAggregator")) : class$etm$core$aggregation$persistence$PersistentRootAggregator, "A cummulating aggregator for nested and flat representation that restores previous state from a persistence backend.", false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

