/*
 * Decompiled with CFR 0.152.
 */
package etm.core.configuration;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class PropertyConfig {
    private Map properties;

    public Map getProperties() {
        return this.properties;
    }

    public void addProperty(String propertyName, String propertyValue) {
        int dotIndex;
        if (propertyValue.startsWith("${") && propertyValue.endsWith("}")) {
            String systemKey = propertyValue.substring(2, propertyValue.length() - 1);
            propertyValue = System.getProperty(systemKey, propertyValue);
        }
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if ((dotIndex = propertyName.indexOf(".")) > 0) {
            String name = propertyName.substring(0, dotIndex);
            String key = propertyName.substring(dotIndex + 1);
            if (this.properties.containsKey(name)) {
                ((Map)this.properties.get(name)).put(key, propertyValue);
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(key, propertyValue);
                this.properties.put(name, map);
            }
        } else if (this.properties.containsKey(propertyName)) {
            Object currentValue = this.properties.get(propertyName);
            LinkedList<Object> valueList = new LinkedList<Object>();
            valueList.add(currentValue);
            valueList.add(propertyValue);
            this.properties.put(propertyName, valueList);
        } else {
            this.properties.put(propertyName, propertyValue);
        }
    }
}

