/*
 * Decompiled with CFR 0.152.
 */
package etm.core.configuration;

import etm.core.configuration.EtmAggregatorConfig;
import etm.core.configuration.EtmConfigurationException;
import etm.core.configuration.EtmMonitorConfig;
import etm.core.configuration.EtmPluginConfig;
import etm.core.configuration.XmlConfigParser;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class Xml12ConfigParser
extends XmlConfigParser {
    private static final LogAdapter log = Log.getLog(class$etm$core$configuration$Xml12ConfigParser == null ? (class$etm$core$configuration$Xml12ConfigParser = Xml12ConfigParser.class$("etm.core.configuration.Xml12ConfigParser")) : class$etm$core$configuration$Xml12ConfigParser);
    static /* synthetic */ Class class$etm$core$configuration$Xml12ConfigParser;
    static /* synthetic */ Class class$etm$core$aggregation$persistence$PersistentRootAggregator;
    static /* synthetic */ Class class$etm$core$aggregation$RootAggregator;
    static /* synthetic */ Class class$etm$core$aggregation$BufferedThresholdAggregator;
    static /* synthetic */ Class class$etm$core$aggregation$BufferedTimedAggregator;
    static /* synthetic */ Class class$etm$core$aggregation$NotifyingAggregator;
    static /* synthetic */ Class class$etm$core$jmx$EtmMonitorJmxPlugin;

    Xml12ConfigParser() {
    }

    public EtmMonitorConfig parse(Document aDocument) {
        String timer;
        String type;
        EtmMonitorConfig monitorConfig = new EtmMonitorConfig();
        Element documentElement = aDocument.getDocumentElement();
        String attribute = this.getAttribute(documentElement, "autostart");
        if ("true".equals(attribute)) {
            monitorConfig.setAutostart(true);
        }
        if ((type = this.getAttribute(documentElement, "type")) != null && type.length() > 0) {
            monitorConfig.setMonitorType(type);
        }
        if ((timer = this.getAttribute(documentElement, "timer")) != null && timer.length() > 0) {
            monitorConfig.setTimerType(timer);
        }
        NodeList features = documentElement.getElementsByTagName("features");
        NodeList aggregatorChain = documentElement.getElementsByTagName("aggregator-chain");
        if (features.getLength() != 0) {
            this.parseFeatures(features, monitorConfig);
        } else if (aggregatorChain.getLength() != 0) {
            this.parseChain(aggregatorChain, monitorConfig);
        }
        NodeList extension = documentElement.getElementsByTagName("extension");
        if (extension.getLength() != 0) {
            NodeList plugins = ((Element)extension.item(0)).getElementsByTagName("plugin");
            for (int i = 0; i < plugins.getLength(); ++i) {
                Element plugin = (Element)plugins.item(i);
                EtmPluginConfig pluginConfig = this.extractPluginConfig(plugin);
                monitorConfig.addExtension(pluginConfig);
            }
        }
        return monitorConfig;
    }

    protected void parseFeatures(NodeList features, EtmMonitorConfig aMonitorConfig) {
        EtmAggregatorConfig aggregatorConfig;
        EtmAggregatorConfig aggregatorConfig2;
        Element element;
        Element featureConfig = (Element)features.item(0);
        NodeList thresholdBuffer = featureConfig.getElementsByTagName("threshold-buffer");
        NodeList intervalBuffer = featureConfig.getElementsByTagName("interval-buffer");
        NodeList notifications = featureConfig.getElementsByTagName("notifications");
        NodeList persistence = featureConfig.getElementsByTagName("persistence");
        NodeList jmxConfig = featureConfig.getElementsByTagName("jmx");
        NodeList rawDataConfig = featureConfig.getElementsByTagName("raw-data-log");
        if (persistence.getLength() != 0) {
            element = (Element)persistence.item(0);
            aggregatorConfig2 = new EtmAggregatorConfig();
            aggregatorConfig2.setAggregatorClass(class$etm$core$aggregation$persistence$PersistentRootAggregator == null ? (class$etm$core$aggregation$persistence$PersistentRootAggregator = Xml12ConfigParser.class$("etm.core.aggregation.persistence.PersistentRootAggregator")) : class$etm$core$aggregation$persistence$PersistentRootAggregator);
            NodeList fileBackend = element.getElementsByTagName("file-backend");
            NodeList customBackend = element.getElementsByTagName("custom-backend");
            if (fileBackend.getLength() != 0) {
                Element fileBackendElement = (Element)fileBackend.item(0);
                this.addPropertyByAttribute(fileBackendElement, aggregatorConfig2, "filename", "backendProperties.filename");
                this.addPropertyByAttribute(fileBackendElement, aggregatorConfig2, "path", "backendProperties.path");
            } else if (customBackend.getLength() != 0) {
                Element customBackendElement = (Element)customBackend.item(0);
                this.addPropertyByAttribute(customBackendElement, aggregatorConfig2, "class", "persistenceBackendClass");
                NodeList properties = customBackendElement.getElementsByTagName("property");
                for (int j = 0; j < properties.getLength(); ++j) {
                    Element property = (Element)properties.item(j);
                    aggregatorConfig2.addProperty("backendProperties." + this.getAttribute(property, "name"), this.getNodeFirstChildTextValue(property));
                }
            }
            aMonitorConfig.setAggregatorRoot(aggregatorConfig2);
        } else {
            aggregatorConfig = new EtmAggregatorConfig();
            aggregatorConfig.setAggregatorClass(class$etm$core$aggregation$RootAggregator == null ? (class$etm$core$aggregation$RootAggregator = Xml12ConfigParser.class$("etm.core.aggregation.RootAggregator")) : class$etm$core$aggregation$RootAggregator);
            aMonitorConfig.setAggregatorRoot(aggregatorConfig);
        }
        if (thresholdBuffer.getLength() != 0) {
            element = (Element)thresholdBuffer.item(0);
            aggregatorConfig2 = new EtmAggregatorConfig();
            aggregatorConfig2.setAggregatorClass(class$etm$core$aggregation$BufferedThresholdAggregator == null ? (class$etm$core$aggregation$BufferedThresholdAggregator = Xml12ConfigParser.class$("etm.core.aggregation.BufferedThresholdAggregator")) : class$etm$core$aggregation$BufferedThresholdAggregator);
            this.addPropertyByAttribute(element, aggregatorConfig2, "threshold", "threshold");
            aMonitorConfig.appendAggregator(aggregatorConfig2);
        } else if (intervalBuffer.getLength() != 0) {
            element = (Element)intervalBuffer.item(0);
            aggregatorConfig2 = new EtmAggregatorConfig();
            aggregatorConfig2.setAggregatorClass(class$etm$core$aggregation$BufferedTimedAggregator == null ? (class$etm$core$aggregation$BufferedTimedAggregator = Xml12ConfigParser.class$("etm.core.aggregation.BufferedTimedAggregator")) : class$etm$core$aggregation$BufferedTimedAggregator);
            this.addPropertyByAttribute(element, aggregatorConfig2, "interval", "aggregationInterval");
            aMonitorConfig.appendAggregator(aggregatorConfig2);
        }
        if (notifications.getLength() != 0) {
            if (thresholdBuffer.getLength() == 0 && intervalBuffer.getLength() == 0) {
                log.warn("Missing buffering aggregator while notifications enabled. Adding BufferedThresholdAggregator.");
                aggregatorConfig = new EtmAggregatorConfig();
                aggregatorConfig.setAggregatorClass(class$etm$core$aggregation$BufferedThresholdAggregator == null ? (class$etm$core$aggregation$BufferedThresholdAggregator = Xml12ConfigParser.class$("etm.core.aggregation.BufferedThresholdAggregator")) : class$etm$core$aggregation$BufferedThresholdAggregator);
                aMonitorConfig.appendAggregator(aggregatorConfig);
            }
            element = (Element)notifications.item(0);
            aggregatorConfig2 = new EtmAggregatorConfig();
            aggregatorConfig2.setAggregatorClass(class$etm$core$aggregation$NotifyingAggregator == null ? (class$etm$core$aggregation$NotifyingAggregator = Xml12ConfigParser.class$("etm.core.aggregation.NotifyingAggregator")) : class$etm$core$aggregation$NotifyingAggregator);
            this.addPropertyByAttribute(element, aggregatorConfig2, "rootOnly", "rootOnly");
            this.addPropertyByAttribute(element, aggregatorConfig2, "filter-pattern", "filterPattern");
            aMonitorConfig.appendAggregator(aggregatorConfig2);
        }
        if (rawDataConfig.getLength() != 0) {
            element = (Element)rawDataConfig.item(0);
            aggregatorConfig2 = new EtmAggregatorConfig();
            String type = element.getAttribute("type");
            if ("log4j".equals(type)) {
                aggregatorConfig2.setAggregatorClass("etm.contrib.aggregation.log.Log4jAggregator");
            } else if ("jdk14".equals(type)) {
                aggregatorConfig2.setAggregatorClass("etm.contrib.aggregation.log.Jdk14LogAggregator");
            } else if ("commons".equals(type)) {
                aggregatorConfig2.setAggregatorClass("etm.contrib.aggregation.log.CommonsLoggingAggregator");
            }
            this.addPropertyByAttribute(element, aggregatorConfig2, "category", "logName");
            this.addPropertyByAttribute(element, aggregatorConfig2, "formatter-class", "formatterClass");
            this.addPropertyByAttribute(element, aggregatorConfig2, "filter-pattern", "filterPattern");
            aMonitorConfig.appendAggregator(aggregatorConfig2);
        }
        if (jmxConfig.getLength() != 0) {
            Element jmxConfigElement = (Element)jmxConfig.item(0);
            EtmPluginConfig config = new EtmPluginConfig();
            config.setPluginClass(class$etm$core$jmx$EtmMonitorJmxPlugin == null ? (class$etm$core$jmx$EtmMonitorJmxPlugin = Xml12ConfigParser.class$("etm.core.jmx.EtmMonitorJmxPlugin")) : class$etm$core$jmx$EtmMonitorJmxPlugin);
            this.addPropertyByAttribute(jmxConfigElement, config, "mbeanServerName", "mbeanServerName");
            this.addPropertyByAttribute(jmxConfigElement, config, "monitorObjectName", "monitorObjectName");
            this.addPropertyByAttribute(jmxConfigElement, config, "measurementDomain", "measurementDomain");
            this.addPropertyByAttribute(jmxConfigElement, config, "overwrite", "overwrite");
            aMonitorConfig.addExtension(config);
        }
    }

    protected void parseChain(NodeList aAggregatorChain, EtmMonitorConfig aMonitorConfig) {
        Element element = (Element)aAggregatorChain.item(0);
        NodeList aggregatorRoot = element.getElementsByTagName("chain-root");
        if (aggregatorRoot.getLength() == 0) {
            EtmAggregatorConfig aggregatorConfig = new EtmAggregatorConfig();
            aggregatorConfig.setAggregatorClass(class$etm$core$aggregation$RootAggregator == null ? (class$etm$core$aggregation$RootAggregator = Xml12ConfigParser.class$("etm.core.aggregation.RootAggregator")) : class$etm$core$aggregation$RootAggregator);
            aMonitorConfig.setAggregatorRoot(aggregatorConfig);
        } else {
            EtmAggregatorConfig rootConfig = this.extractAggregatorConfig((Element)aggregatorRoot.item(0));
            aMonitorConfig.setAggregatorRoot(rootConfig);
        }
        NodeList aggregators = element.getElementsByTagName("chain-element");
        for (int i = 0; i < aggregators.getLength(); ++i) {
            Element aggregator = (Element)aggregators.item(i);
            EtmAggregatorConfig aggregatorConfig = this.extractAggregatorConfig(aggregator);
            aMonitorConfig.appendAggregator(aggregatorConfig);
        }
    }

    protected EtmPluginConfig extractPluginConfig(Element aPlugin) {
        EtmPluginConfig pluginConfig = new EtmPluginConfig();
        String pluginClass = aPlugin.getAttribute("class");
        if (pluginClass == null || pluginClass.length() <= 0) {
            throw new EtmConfigurationException("No valid plugin class found");
        }
        pluginConfig.setPluginClass(pluginClass);
        NodeList properties = aPlugin.getElementsByTagName("property");
        for (int j = 0; j < properties.getLength(); ++j) {
            Element property = (Element)properties.item(j);
            pluginConfig.addProperty(this.getAttribute(property, "name"), this.getNodeFirstChildTextValue(property));
        }
        return pluginConfig;
    }

    protected EtmAggregatorConfig extractAggregatorConfig(Element aAggregator) {
        EtmAggregatorConfig aggregatorConfig = new EtmAggregatorConfig();
        String aggregatorClass = aAggregator.getAttribute("class");
        if (aggregatorClass == null || aggregatorClass.length() <= 0) {
            throw new EtmConfigurationException("No valid aggregator class in cahin element found");
        }
        aggregatorConfig.setAggregatorClass(aggregatorClass);
        NodeList properties = aAggregator.getElementsByTagName("property");
        for (int j = 0; j < properties.getLength(); ++j) {
            Element property = (Element)properties.item(j);
            aggregatorConfig.addProperty(this.getAttribute(property, "name"), this.getNodeFirstChildTextValue(property));
        }
        return aggregatorConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

