/*
 * Decompiled with CFR 0.152.
 */
package etm.core.configuration;

import etm.core.configuration.EtmConfigurationException;
import etm.core.configuration.EtmMonitorConfig;
import etm.core.configuration.PropertyConfig;
import etm.core.configuration.Xml10ConfigParser;
import etm.core.configuration.Xml12ConfigParser;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XmlConfigParser {
    public static final String PUBLIC_DTD_1_0 = "-// void.fm //DTD JETM Config 1.0//EN";
    public static final String JETM_CONFIG_1_0_DTD_NAME = "jetm_config_1_0.dtd";
    public static final String PUBLIC_DTD_1_2 = "-// void.fm //DTD JETM Config 1.2//EN";
    public static final String JETM_CONFIG_1_2_DTD_NAME = "jetm_config_1_2.dtd";
    static /* synthetic */ Class class$etm$core$monitor$EtmMonitor;

    public abstract EtmMonitorConfig parse(Document var1);

    public static EtmMonitorConfig extractConfig(InputStream inStream) throws Exception {
        Document document = XmlConfigParser.load(inStream);
        XmlConfigParser parser = XmlConfigParser.getParser(document.getDoctype().getPublicId());
        return parser.parse(document);
    }

    protected static XmlConfigParser getParser(String publicId) {
        if (PUBLIC_DTD_1_0.equals(publicId)) {
            return new Xml10ConfigParser();
        }
        if (PUBLIC_DTD_1_2.equals(publicId)) {
            return new Xml12ConfigParser();
        }
        throw new EtmConfigurationException("Unsupported public ID " + publicId);
    }

    protected static Document load(InputStream inStream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string1) throws SAXException {
                if (XmlConfigParser.PUBLIC_DTD_1_0.equals(string)) {
                    return new InputSource((class$etm$core$monitor$EtmMonitor == null ? (class$etm$core$monitor$EtmMonitor = XmlConfigParser.class$("etm.core.monitor.EtmMonitor")) : class$etm$core$monitor$EtmMonitor).getClassLoader().getResourceAsStream(XmlConfigParser.JETM_CONFIG_1_0_DTD_NAME));
                }
                if (XmlConfigParser.PUBLIC_DTD_1_2.equals(string)) {
                    return new InputSource((class$etm$core$monitor$EtmMonitor == null ? (class$etm$core$monitor$EtmMonitor = XmlConfigParser.class$("etm.core.monitor.EtmMonitor")) : class$etm$core$monitor$EtmMonitor).getClassLoader().getResourceAsStream(XmlConfigParser.JETM_CONFIG_1_2_DTD_NAME));
                }
                throw new SAXException("Unsupported entity " + string);
            }
        });
        return documentBuilder.parse(inStream);
    }

    protected String getAttribute(Element element, String attributeName) {
        String attribute = element.getAttribute(attributeName);
        if (attribute != null) {
            return attribute.trim();
        }
        return attribute;
    }

    protected String getNodeFirstChildTextValue(Node aNode) {
        String nodeValue = aNode.getFirstChild().getNodeValue();
        if (nodeValue != null) {
            return nodeValue.trim();
        }
        return nodeValue;
    }

    protected void addPropertyByAttribute(Element aElement, PropertyConfig aConfig, String aAttributeName, String aPropertyName) {
        String path = aElement.getAttribute(aAttributeName);
        if (path != null && path.length() > 0) {
            aConfig.addProperty(aPropertyName, path);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

