/*
 * Decompiled with CFR 0.152.
 */
package etm.core.jmx;

import etm.core.aggregation.Aggregate;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.util.Hashtable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class JmxSupport {
    private static final LogAdapter log = Log.getLog(class$etm$core$jmx$JmxSupport == null ? (class$etm$core$jmx$JmxSupport = JmxSupport.class$("etm.core.jmx.JmxSupport")) : class$etm$core$jmx$JmxSupport);
    static /* synthetic */ Class class$etm$core$jmx$JmxSupport;

    JmxSupport() {
    }

    protected void registerMBean(MBeanServer mbeanServer, ObjectName objectName, Object object, boolean overwrite) throws JMException {
        try {
            mbeanServer.registerMBean(object, objectName);
        }
        catch (InstanceAlreadyExistsException e) {
            if (overwrite) {
                mbeanServer.unregisterMBean(objectName);
                mbeanServer.registerMBean(object, objectName);
            }
            log.warn("Error registering EtmMonitor MBean. An instance called " + objectName + " already exists.");
        }
    }

    protected ObjectName calculateObjectName(String measurementDomain, Aggregate aAggregate) throws JMException {
        char[] chars = aAggregate.getName().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case ',': 
                case ':': 
                case ';': {
                    chars[i] = 95;
                }
            }
        }
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("type", "Measurement");
        map.put("name", new String(chars));
        return new ObjectName(measurementDomain, map);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

