/*
 * Decompiled with CFR 0.152.
 */
package etm.core.jmx;

import etm.core.aggregation.Aggregate;
import etm.core.jmx.ManagedEtmMonitorMBean;
import etm.core.metadata.AggregatorMetaData;
import etm.core.monitor.EtmException;
import etm.core.monitor.EtmMonitor;
import etm.core.renderer.MeasurementRenderer;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class ManagedEtmMonitor
implements ManagedEtmMonitorMBean {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private EtmMonitor monitor;
    private MeasurementRenderer textRenderer;
    private CharArrayWriter writer;

    public ManagedEtmMonitor(EtmMonitor aMonitor) {
        this(aMonitor, Locale.getDefault());
    }

    public ManagedEtmMonitor(EtmMonitor aMonitor, Locale locale) {
        this.monitor = aMonitor;
        this.writer = new CharArrayWriter();
        this.textRenderer = new HtmlRenderer(this.writer, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String showHtmlInfos() {
        try {
            this.monitor.render(this.textRenderer);
            String string = this.writer.toString();
            return string;
        }
        finally {
            this.writer.reset();
        }
    }

    public synchronized void reset() {
        this.monitor.reset();
    }

    public Date getStartTime() {
        return this.monitor.getMetaData().getStartTime();
    }

    public Date getLastResetTime() {
        return this.monitor.getMetaData().getLastResetTime();
    }

    public String getMonitorImplementationClass() {
        return this.monitor.getMetaData().getImplementationClass().getName();
    }

    public String getMonitorDescription() {
        return this.monitor.getMetaData().getDescription();
    }

    public String getTimerImplementationClass() {
        return this.monitor.getMetaData().getTimerMetaData().getImplementationClass().getName();
    }

    public String getTimerDescription() {
        return this.monitor.getMetaData().getTimerMetaData().getDescription();
    }

    public long getTimerTicksPerSecond() {
        return this.monitor.getMetaData().getTimerMetaData().getTicksPerSecond();
    }

    public String[] getAggregatorChain() {
        ArrayList<String> list = new ArrayList<String>();
        for (AggregatorMetaData aggregatorMetaData = this.monitor.getMetaData().getAggregatorMetaData(); aggregatorMetaData != null; aggregatorMetaData = aggregatorMetaData.getNestedMetaData()) {
            list.add(aggregatorMetaData.toString() + LINE_SEPARATOR);
        }
        return list.toArray(new String[list.size()]);
    }

    public void start() {
        this.monitor.start();
    }

    public void stop() {
        this.monitor.stop();
    }

    public boolean isStarted() {
        return this.monitor.isStarted();
    }

    class HtmlRenderer
    implements MeasurementRenderer {
        private static final String TREE_SIGN = "|-";
        private static final String HEAD = "<table border=\"1\" cellpadding=\"5\" >\n <tr>\n  <th>Etm Point</th>\n  <th>Measurements</th>\n  <th>Average</th>\n  <th>Min/Max</th>\n  <th>Total Time</th>\n </tr>\n";
        private static final String FOOTER = "</table>";
        private NumberFormat timeFormatter;
        private Writer responseWriter;
        private static final String SPACE = "&nbsp;";

        public HtmlRenderer(Writer aWriter, Locale aLocale) {
            this.responseWriter = aWriter;
            this.timeFormatter = NumberFormat.getNumberInstance(aLocale);
            this.timeFormatter.setMaximumFractionDigits(3);
            this.timeFormatter.setMinimumFractionDigits(3);
            this.timeFormatter.setGroupingUsed(true);
        }

        public void render(Map points) {
            try {
                this.responseWriter.write(HEAD.toCharArray());
                StringBuffer buffer = new StringBuffer();
                TreeMap map = new TreeMap(points);
                Iterator iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    Aggregate point = (Aggregate)iterator.next();
                    buffer.append(" <tr>\n");
                    buffer.append("  <td align=\"left\">");
                    this.writeNames(buffer, point, 0);
                    buffer.append("</td>\n");
                    buffer.append("  <td align=\"right\">");
                    this.writeMeasurements(buffer, point, 0);
                    buffer.append("</td>\n");
                    buffer.append("  <td align=\"right\">");
                    this.writeTime(buffer, point, 0);
                    buffer.append("</td>\n");
                    buffer.append("  <td align=\"right\">");
                    this.writeMinMax(buffer, point, 0);
                    buffer.append("</td>\n");
                    buffer.append("  <td align=\"right\">");
                    this.writeTotals(buffer, point, 0);
                    buffer.append("</td>\n");
                    buffer.append(" </tr>\n");
                }
                this.responseWriter.write(buffer.toString().toCharArray());
                this.responseWriter.write(FOOTER.toCharArray());
                this.responseWriter.flush();
            }
            catch (IOException e) {
                throw new EtmException("Unable to write to writer: " + e);
            }
        }

        private void writeNames(StringBuffer aBuffer, Aggregate aPoint, int depth) {
            if (depth > 0) {
                this.writeNestingLevel(aBuffer, depth);
                aBuffer.append(TREE_SIGN);
            }
            aBuffer.append(aPoint.getName());
            aBuffer.append("<br />");
            if (aPoint.hasChilds()) {
                int currentDepth = depth + 1;
                Map childs = aPoint.getChilds();
                Iterator iterator = childs.values().iterator();
                while (iterator.hasNext()) {
                    Aggregate child = (Aggregate)iterator.next();
                    this.writeNames(aBuffer, child, currentDepth);
                }
            }
        }

        private void writeTotals(StringBuffer aBuffer, Aggregate aPoint, int depth) {
            aBuffer.append(this.timeFormatter.format(aPoint.getTotal()));
            aBuffer.append("<br />");
            if (aPoint.hasChilds()) {
                Map childs = aPoint.getChilds();
                int currentDepth = depth + 1;
                Iterator iterator = childs.values().iterator();
                while (iterator.hasNext()) {
                    Aggregate child = (Aggregate)iterator.next();
                    this.writeTotals(aBuffer, child, currentDepth);
                }
            }
        }

        private void writeTime(StringBuffer aBuffer, Aggregate aPoint, int depth) {
            aBuffer.append(this.timeFormatter.format(aPoint.getAverage()));
            aBuffer.append("<br />");
            if (aPoint.hasChilds()) {
                Map childs = aPoint.getChilds();
                int currentDepth = depth + 1;
                Iterator iterator = childs.values().iterator();
                while (iterator.hasNext()) {
                    Aggregate child = (Aggregate)iterator.next();
                    this.writeTime(aBuffer, child, currentDepth + 1);
                }
            }
        }

        private void writeMinMax(StringBuffer aBuffer, Aggregate aPoint, int depth) {
            aBuffer.append(this.timeFormatter.format(aPoint.getMin()));
            aBuffer.append("/");
            aBuffer.append(this.timeFormatter.format(aPoint.getMax()));
            aBuffer.append("<br />");
            if (aPoint.hasChilds()) {
                Map childs = aPoint.getChilds();
                int currentDepth = depth + 1;
                Iterator iterator = childs.values().iterator();
                while (iterator.hasNext()) {
                    Aggregate child = (Aggregate)iterator.next();
                    this.writeMinMax(aBuffer, child, currentDepth + 1);
                }
            }
        }

        private void writeMeasurements(StringBuffer aBuffer, Aggregate aPoint, int depth) {
            aBuffer.append(aPoint.getMeasurements());
            aBuffer.append("<br />");
            if (aPoint.hasChilds()) {
                Map childs = aPoint.getChilds();
                int currentDepth = depth + 1;
                Iterator iterator = childs.values().iterator();
                while (iterator.hasNext()) {
                    Aggregate child = (Aggregate)iterator.next();
                    this.writeMeasurements(aBuffer, child, currentDepth);
                }
            }
        }

        protected void writeNestingLevel(StringBuffer buffer, int newDepth) {
            for (int i = 0; i < newDepth; ++i) {
                buffer.append(SPACE);
            }
        }
    }
}

