/*
 * Decompiled with CFR 0.152.
 */
package etm.core.monitor;

import etm.core.aggregation.Aggregator;
import etm.core.aggregation.BufferedThresholdAggregator;
import etm.core.aggregation.RootAggregator;
import etm.core.configuration.EtmMonitorFactory;
import etm.core.metadata.EtmMonitorMetaData;
import etm.core.metadata.PluginMetaData;
import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmMonitorContext;
import etm.core.monitor.EtmPoint;
import etm.core.monitor.MeasurementPoint;
import etm.core.monitor.event.AggregationStateListener;
import etm.core.monitor.event.AggregationStateLoadedEvent;
import etm.core.monitor.event.CollectionDisabledEvent;
import etm.core.monitor.event.CollectionEnabledEvent;
import etm.core.monitor.event.DefaultEventDispatcher;
import etm.core.monitor.event.EtmMonitorEvent;
import etm.core.monitor.event.EtmMonitorListener;
import etm.core.monitor.event.EventDispatcher;
import etm.core.plugin.EtmPlugin;
import etm.core.renderer.MeasurementRenderer;
import etm.core.timer.ExecutionTimer;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import etm.core.util.Version;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;

public abstract class EtmMonitorSupport
implements EtmMonitor,
AggregationStateListener {
    private static final LogAdapter log = Log.getLog(class$etm$core$monitor$EtmMonitor == null ? (class$etm$core$monitor$EtmMonitor = EtmMonitorSupport.class$("etm.core.monitor.EtmMonitor")) : class$etm$core$monitor$EtmMonitor);
    protected final String description;
    protected final ExecutionTimer timer;
    protected final Aggregator aggregator;
    protected List plugins;
    private Timer scheduler;
    private EventDispatcher dispatcher;
    private Date startTime;
    private Date lastReset;
    private boolean started = false;
    private boolean collecting = true;
    private boolean noStartedErrorMessageFlag = false;
    static /* synthetic */ Class class$etm$core$monitor$EtmMonitor;

    protected EtmMonitorSupport(String aDescription, ExecutionTimer aTimer, Aggregator aAggregator) {
        this.description = aDescription;
        this.timer = aTimer != null ? aTimer : EtmMonitorFactory.bestAvailableTimer();
        this.aggregator = aAggregator != null ? aAggregator : this.getDefaultAggregator();
        this.lastReset = this.startTime = new Date();
    }

    public EtmPoint createPoint(String symbolicName) {
        return new MeasurementPoint(this, symbolicName);
    }

    public final void visitPreMeasurement(MeasurementPoint measurementPoint) {
        try {
            if (!this.collecting) {
                return;
            }
            if (!this.started) {
                if (!this.noStartedErrorMessageFlag) {
                    this.showMonitorNotStartedMessage();
                }
                return;
            }
            if (measurementPoint == null) {
                return;
            }
            this.doVisitPreMeasurement(measurementPoint);
            measurementPoint.setTicks(this.timer.getTicksPerSecond());
            measurementPoint.setStartTime(this.timer.getCurrentTime());
        }
        catch (Exception e) {
            log.warn("Caught exception within measurement code. ", e);
        }
    }

    public final void visitPostCollect(MeasurementPoint measurementPoint) {
        if (!this.collecting || !this.started) {
            return;
        }
        if (measurementPoint == null) {
            return;
        }
        try {
            measurementPoint.setEndTime(this.timer.getCurrentTime());
            this.doVisitPostCollect(measurementPoint);
            this.aggregator.add(measurementPoint);
        }
        catch (Exception e) {
            log.warn("Caught exception within measurement code.", e);
        }
    }

    public final void aggregate() {
        this.aggregator.flush();
    }

    public void render(MeasurementRenderer renderer) {
        this.aggregator.render(renderer);
    }

    public void reset() {
        this.aggregator.reset();
        this.lastReset = new Date();
    }

    public void reset(String measurementPoint) {
        this.aggregator.reset(measurementPoint);
    }

    public final EtmMonitorMetaData getMetaData() {
        List pluginMetaData = this.getPluginMetaData();
        return new EtmMonitorMetaData(this.getClass(), this.description, this.startTime, this.lastReset, this.aggregator.getMetaData(), this.timer.getMetaData(), pluginMetaData);
    }

    public void start() {
        if (this.started) {
            this.collecting = true;
            return;
        }
        this.scheduler = new Timer(true);
        if (this.dispatcher == null) {
            this.dispatcher = new DefaultEventDispatcher();
        }
        this.dispatcher.register(this);
        this.startPlugins();
        this.aggregator.init(new EtmMonitorSupportContext(this, this.scheduler));
        this.aggregator.start();
        this.started = true;
        this.collecting = true;
        log.info("JETM " + Version.getVersion() + " started.");
    }

    public void stop() {
        log.info("Shutting down JETM.");
        if (!this.started) {
            this.collecting = false;
            return;
        }
        this.collecting = false;
        this.started = false;
        this.scheduler.cancel();
        this.aggregator.stop();
        this.shutdownPlugins();
        this.dispatcher.deregister(this);
    }

    public boolean isStarted() {
        return this.started;
    }

    public void enableCollection() {
        this.collecting = true;
        this.dispatcher.fire(new CollectionEnabledEvent(this));
    }

    public void disableCollection() {
        this.collecting = false;
        this.dispatcher.fire(new CollectionDisabledEvent(this));
    }

    public boolean isCollecting() {
        return this.collecting;
    }

    public void addPlugin(EtmPlugin aEtmPlugin) {
        if (this.started) {
            throw new IllegalStateException("Monitor already started.");
        }
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        this.plugins.add(aEtmPlugin);
    }

    public void setPlugins(List newPlugins) {
        if (this.plugins != null) {
            throw new IllegalStateException("Unable to set a list of plugins after plugins exists.");
        }
        for (int i = 0; i < newPlugins.size(); ++i) {
            EtmPlugin plugin = (EtmPlugin)newPlugins.get(i);
            this.addPlugin(plugin);
        }
    }

    public void onStateLoaded(AggregationStateLoadedEvent event) {
        this.startTime = event.getState().getStartTime();
        this.lastReset = event.getState().getLastResetTime();
    }

    protected abstract void doVisitPreMeasurement(MeasurementPoint var1);

    protected abstract void doVisitPostCollect(MeasurementPoint var1);

    protected Aggregator getDefaultAggregator() {
        return new BufferedThresholdAggregator(new RootAggregator());
    }

    protected void shutdownPlugins() {
        if (this.plugins != null) {
            for (int i = 0; i < this.plugins.size(); ++i) {
                EtmPlugin etmPlugin = (EtmPlugin)this.plugins.get(i);
                try {
                    if (etmPlugin instanceof EtmMonitorListener) {
                        this.dispatcher.deregister((EtmMonitorListener)((Object)etmPlugin));
                    }
                    etmPlugin.stop();
                    continue;
                }
                catch (Exception e) {
                    log.warn("Error while shutting down " + etmPlugin.getPluginMetaData(), e);
                }
            }
        }
    }

    protected void startPlugins() {
        if (this.plugins != null) {
            for (int i = 0; i < this.plugins.size(); ++i) {
                EtmPlugin etmPlugin = (EtmPlugin)this.plugins.get(i);
                try {
                    etmPlugin.init(new EtmMonitorSupportContext(this, this.scheduler));
                    etmPlugin.start();
                    if (!(etmPlugin instanceof EtmMonitorListener)) continue;
                    this.dispatcher.register((EtmMonitorListener)((Object)etmPlugin));
                    continue;
                }
                catch (Exception e) {
                    log.warn("Error starting plugin " + etmPlugin.getPluginMetaData() + ". Keep plugin disabled. ", e);
                }
            }
        }
    }

    private List getPluginMetaData() {
        if (this.plugins != null) {
            ArrayList<PluginMetaData> metaData = new ArrayList<PluginMetaData>(this.plugins.size());
            for (int i = 0; i < this.plugins.size(); ++i) {
                metaData.add(((EtmPlugin)this.plugins.get(i)).getPluginMetaData());
            }
            return metaData;
        }
        return null;
    }

    private void showMonitorNotStartedMessage() {
        log.warn("Warning - Performance Monitoring currently disabled. If you did not start the current EtmMonitor on purpose, you may ignore this warning. Otherwhise ensure to call EtmMonitor.start() at some point in your application.");
        this.noStartedErrorMessageFlag = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class EtmMonitorSupportContext
    implements EtmMonitorContext {
        private EtmMonitor monitor;
        private Timer scheduler;

        public EtmMonitorSupportContext(EtmMonitor aMonitor, Timer aScheduler) {
            this.monitor = aMonitor;
            this.scheduler = aScheduler;
        }

        public EtmMonitor getEtmMonitor() {
            return this.monitor;
        }

        public Timer getScheduler() {
            return this.scheduler;
        }

        public void fireEvent(EtmMonitorEvent event) {
            EtmMonitorSupport.this.dispatcher.fire(event);
        }
    }
}

