/*
 * Decompiled with CFR 0.152.
 */
package etm.core.monitor;

import etm.core.aggregation.Aggregator;
import etm.core.metadata.AggregatorMetaData;
import etm.core.monitor.EtmMonitorContext;
import etm.core.monitor.EtmMonitorSupport;
import etm.core.monitor.EtmPoint;
import etm.core.monitor.MeasurementPoint;
import etm.core.renderer.MeasurementRenderer;
import etm.core.util.Log;
import etm.core.util.LogAdapter;

public class NullMonitor
extends EtmMonitorSupport {
    private static final LogAdapter log = Log.getLog(class$etm$core$monitor$NullMonitor == null ? (class$etm$core$monitor$NullMonitor = NullMonitor.class$("etm.core.monitor.NullMonitor")) : class$etm$core$monitor$NullMonitor);
    private static final String DESCRIPTION = "A monitor that does not record executions at all.";
    private boolean notCollectionWarningFlag = false;
    static /* synthetic */ Class class$etm$core$monitor$NullMonitor;
    static /* synthetic */ Class class$etm$core$monitor$NullMonitor$NullAggregator;

    public NullMonitor() {
        super(DESCRIPTION, null, null);
    }

    protected void doVisitPreMeasurement(MeasurementPoint aMeasurementPoint) {
        if (!this.notCollectionWarningFlag) {
            this.showWarning();
        }
    }

    protected void doVisitPostCollect(MeasurementPoint aPoint) {
    }

    public void render(MeasurementRenderer renderer) {
        if (!this.notCollectionWarningFlag) {
            this.showWarning();
        }
    }

    public String toString() {
        return "etm.core.monitor.NullMonitor{ timer=<none>, aggregator=<none> }";
    }

    protected Aggregator getDefaultAggregator() {
        return new NullAggregator();
    }

    private void showWarning() {
        log.warn("Warning - NullMonitor active. Performance results are discarded.This usually happens if you used EtmManager.getEtmMonitor() to retrieve the current EtmMonitor instance and did not configure the Performance sub system before. For further details see EtmManager documentation at http://jetm.void.fm/howto/etm_manager_configuration.html");
        this.notCollectionWarningFlag = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class NullAggregator
    implements Aggregator {
        NullAggregator() {
        }

        public void add(EtmPoint point) {
        }

        public void flush() {
        }

        public void reset() {
        }

        public void reset(String symbolicName) {
        }

        public void render(MeasurementRenderer renderer) {
        }

        public AggregatorMetaData getMetaData() {
            return new AggregatorMetaData(class$etm$core$monitor$NullMonitor$NullAggregator == null ? (class$etm$core$monitor$NullMonitor$NullAggregator = NullMonitor.class$("etm.core.monitor.NullMonitor$NullAggregator")) : class$etm$core$monitor$NullMonitor$NullAggregator, "Mock aggregator - discards all performance results.", false);
        }

        public void start() {
        }

        public void stop() {
        }

        public void init(EtmMonitorContext ctx) {
        }
    }
}

