/*
 * Decompiled with CFR 0.152.
 */
package etm.core.renderer;

import etm.core.aggregation.Aggregate;
import etm.core.monitor.EtmException;
import etm.core.renderer.MeasurementRenderer;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class SimpleTextRenderer
implements MeasurementRenderer {
    private final NumberFormat timeFormatter;
    private final Writer writer;
    private final String separator = System.getProperty("line.separator");

    public SimpleTextRenderer() {
        this((Writer)new OutputStreamWriter(System.out), Locale.getDefault());
    }

    public SimpleTextRenderer(Writer aWriter) {
        this(aWriter, Locale.getDefault());
    }

    public SimpleTextRenderer(Locale locale) {
        this((Writer)new OutputStreamWriter(System.out), locale);
    }

    public SimpleTextRenderer(Writer aWriter, Locale aLocale) {
        this.writer = aWriter;
        this.timeFormatter = NumberFormat.getNumberInstance(aLocale);
        this.timeFormatter.setMaximumFractionDigits(3);
        this.timeFormatter.setMinimumFractionDigits(3);
        this.timeFormatter.setGroupingUsed(true);
    }

    public SimpleTextRenderer(NumberFormat aTimeFormatter) {
        this.writer = new OutputStreamWriter(System.out);
        this.timeFormatter = aTimeFormatter;
    }

    public SimpleTextRenderer(Writer aWriter, NumberFormat aTimeFormatter) {
        this.writer = aWriter;
        this.timeFormatter = aTimeFormatter;
    }

    public void render(Map points) {
        Results results = new Results(points);
        try {
            results.render(this.writer);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new EtmException("Unable to write to writer: " + e);
        }
    }

    class SeparatorEntry
    implements ColumnEntry {
        SeparatorEntry() {
        }

        public int getCurrentLength() {
            return 0;
        }

        public void write(Writer writer, int totalWidth) throws IOException {
            for (int i = 0; i < totalWidth; ++i) {
                writer.write(45);
            }
        }
    }

    class CenteredEntry
    implements ColumnEntry {
        private String text;

        public CenteredEntry(String aText) {
            this.text = aText;
        }

        public int getCurrentLength() {
            return this.text.length() + 2;
        }

        public void write(Writer writer, int totalWidth) throws IOException {
            if (totalWidth == this.getCurrentLength()) {
                writer.write(32);
                writer.write(this.text);
                writer.write(32);
            } else {
                int i;
                int posfix;
                int prefix;
                int remaining = totalWidth - this.text.length();
                if (remaining % 2 == 1) {
                    prefix = ++remaining / 2;
                    posfix = prefix - 1;
                } else {
                    posfix = prefix = remaining / 2;
                }
                for (i = 0; i < prefix; ++i) {
                    writer.write(32);
                }
                writer.write(this.text);
                for (i = 0; i < posfix; ++i) {
                    writer.write(32);
                }
            }
        }
    }

    class RightAlignedEntry
    implements ColumnEntry {
        private String text;

        public RightAlignedEntry(String aText) {
            this.text = aText;
        }

        public int getCurrentLength() {
            return this.text.length() + 2;
        }

        public void write(Writer writer, int totalWidth) throws IOException {
            writer.write(32);
            if (this.text.length() == totalWidth) {
                writer.write(this.text);
            } else {
                for (int i = 0; i < totalWidth - this.text.length() - 2; ++i) {
                    writer.write(32);
                }
                writer.write(this.text);
            }
            writer.write(32);
        }
    }

    class NestedEntry
    implements ColumnEntry {
        private int nestingLevel;
        private String text;

        public NestedEntry(int aNestingLevel, String aText) {
            this.nestingLevel = aNestingLevel;
            this.text = aText;
        }

        public int getCurrentLength() {
            return 2 * this.nestingLevel + this.text.length() + 2;
        }

        public void write(Writer writer, int totalWidth) throws IOException {
            int i;
            writer.write(32);
            for (i = 0; i < this.nestingLevel * 2; ++i) {
                writer.write(32);
            }
            writer.write(this.text);
            for (i = 0; i < totalWidth - this.nestingLevel * 2 - this.text.length() - 2; ++i) {
                writer.write(32);
            }
            writer.write(32);
        }
    }

    static interface ColumnEntry {
        public int getCurrentLength();

        public void write(Writer var1, int var2) throws IOException;
    }

    class Column {
        private int currentMaxSize = 0;
        private List entries = new ArrayList();

        public Column(String aHeadLine) {
            this.addEntry(new SeparatorEntry());
            this.addEntry(new CenteredEntry(aHeadLine));
            this.addEntry(new SeparatorEntry());
        }

        public void addEntry(ColumnEntry entry) {
            int i = entry.getCurrentLength();
            this.currentMaxSize = this.currentMaxSize > i ? this.currentMaxSize : entry.getCurrentLength();
            this.entries.add(entry);
        }

        public Iterator iterator() {
            return this.entries.iterator();
        }
    }

    class Results {
        private Column nameColumn;
        private Column numberColumn;
        private Column avgColumn;
        private Column minColumn;
        private Column maxColumn;
        private Column totalColumn;

        public Results(Map points) {
            this.nameColumn = new Column("Measurement Point");
            this.numberColumn = new Column("#");
            this.avgColumn = new Column("Average");
            this.minColumn = new Column("Min");
            this.maxColumn = new Column("Max");
            this.totalColumn = new Column("Total");
            TreeMap map = new TreeMap(points);
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Aggregate point = (Aggregate)iterator.next();
                this.addTopLevel(point);
            }
        }

        public void addTopLevel(Aggregate aAggregate) {
            this.addLine(0, aAggregate);
            if (aAggregate.hasChilds()) {
                this.addNested(1, aAggregate.getChilds());
            }
            this.addSeparator();
        }

        public void addNested(int nestingLevel, Map childs) {
            Iterator iterator = childs.values().iterator();
            while (iterator.hasNext()) {
                Aggregate point = (Aggregate)iterator.next();
                this.addLine(nestingLevel, point);
                if (!point.hasChilds()) continue;
                this.addNested(nestingLevel + 1, point.getChilds());
            }
        }

        private void addSeparator() {
            this.nameColumn.addEntry(new SeparatorEntry());
            this.numberColumn.addEntry(new SeparatorEntry());
            this.avgColumn.addEntry(new SeparatorEntry());
            this.minColumn.addEntry(new SeparatorEntry());
            this.maxColumn.addEntry(new SeparatorEntry());
            this.totalColumn.addEntry(new SeparatorEntry());
        }

        public void addLine(int nestingLevel, Aggregate aAggregate) {
            this.nameColumn.addEntry(new NestedEntry(nestingLevel, aAggregate.getName()));
            this.numberColumn.addEntry(new RightAlignedEntry(String.valueOf(aAggregate.getMeasurements())));
            this.avgColumn.addEntry(new RightAlignedEntry(SimpleTextRenderer.this.timeFormatter.format(aAggregate.getAverage())));
            this.minColumn.addEntry(new RightAlignedEntry(SimpleTextRenderer.this.timeFormatter.format(aAggregate.getMin())));
            this.maxColumn.addEntry(new RightAlignedEntry(SimpleTextRenderer.this.timeFormatter.format(aAggregate.getMax())));
            this.totalColumn.addEntry(new RightAlignedEntry(SimpleTextRenderer.this.timeFormatter.format(aAggregate.getTotal())));
        }

        public void render(Writer writer) throws IOException {
            Iterator nameIt = this.nameColumn.iterator();
            Iterator numberIt = this.numberColumn.iterator();
            Iterator avgIt = this.avgColumn.iterator();
            Iterator minIt = this.minColumn.iterator();
            Iterator maxIt = this.maxColumn.iterator();
            Iterator totalIt = this.totalColumn.iterator();
            while (nameIt.hasNext()) {
                writer.write(124);
                ((ColumnEntry)nameIt.next()).write(writer, this.nameColumn.currentMaxSize);
                writer.write(124);
                ((ColumnEntry)numberIt.next()).write(writer, this.numberColumn.currentMaxSize);
                writer.write(124);
                ((ColumnEntry)avgIt.next()).write(writer, this.avgColumn.currentMaxSize);
                writer.write(124);
                ((ColumnEntry)minIt.next()).write(writer, this.minColumn.currentMaxSize);
                writer.write(124);
                ((ColumnEntry)maxIt.next()).write(writer, this.maxColumn.currentMaxSize);
                writer.write(124);
                ((ColumnEntry)totalIt.next()).write(writer, this.totalColumn.currentMaxSize);
                writer.write(124);
                writer.write(SimpleTextRenderer.this.separator);
            }
        }
    }
}

