/*
 * Decompiled with CFR 0.152.
 */
package de.mediathekview.mlib.filmlisten;

import de.mediathekview.mlib.tool.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;

public class DatenFilmlisteUrl
implements Comparable<DatenFilmlisteUrl> {
    public static final String SERVER_ART_AKT = "akt";
    public static final String SERVER_ART_OLD = "old";
    public static final String SERVER_ART_DIFF = "diff";
    public static final String FILM_UPDATE_SERVER_PRIO_1 = "1";
    public static final String FILM_UPDATE_SERVER = "film-update-server";
    public static final String FILM_UPDATE_SERVER_NR = "film-update-server-nr";
    public static final int FILM_UPDATE_SERVER_NR_NR = 0;
    public static final String FILM_UPDATE_SERVER_URL = "film-update-server-url";
    public static final int FILM_UPDATE_SERVER_URL_NR = 1;
    public static final String FILM_UPDATE_SERVER_DATUM = "film-update-server-datum";
    public static final int FILM_UPDATE_SERVER_DATUM_NR = 2;
    public static final String FILM_UPDATE_SERVER_ZEIT = "film-update-server-zeit";
    public static final int FILM_UPDATE_SERVER_ZEIT_NR = 3;
    public static final String FILM_UPDATE_SERVER_PRIO = "film-update-server-prio";
    public static final int FILM_UPDATE_SERVER_PRIO_NR = 4;
    public static final String FILM_UPDATE_SERVER_ART = "film-update-server-art";
    public static final int FILM_UPDATE_SERVER_ART_NR = 5;
    public static final int FILM_UPDATE_SERVER_MAX_ELEM = 6;
    public static final String[] FILM_UPDATE_SERVER_COLUMN_NAMES = new String[]{"film-update-server-nr", "film-update-server-url", "film-update-server-datum", "film-update-server-zeit", "film-update-server-prio", "film-update-server-art"};
    public static final String[] FILM_UPDATE_SERVER_COLUMN_NAMES_ANZEIGE = new String[]{"Nr", "Update-Url", "Datum", "Zeit", "Prio", "Art"};
    public String[] arr;
    private SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public DatenFilmlisteUrl() {
        this.sdf.setTimeZone(new SimpleTimeZone(2, "UTC"));
        this.makeArr();
    }

    public DatenFilmlisteUrl(String url, String prio, String art) {
        this.sdf.setTimeZone(new SimpleTimeZone(2, "UTC"));
        this.makeArr();
        this.arr[1] = url;
        this.arr[4] = prio;
        this.arr[2] = "";
        this.arr[3] = "";
        this.arr[5] = art;
    }

    public DatenFilmlisteUrl(String url, String art) {
        this.sdf.setTimeZone(new SimpleTimeZone(2, "UTC"));
        this.makeArr();
        this.arr[1] = url;
        this.arr[4] = FILM_UPDATE_SERVER_PRIO_1;
        this.arr[2] = "";
        this.arr[3] = "";
        this.arr[5] = art;
    }

    public Date getDate() {
        Date d;
        String date = this.arr[2] + " " + this.arr[3];
        try {
            d = this.sdf.parse(date);
        }
        catch (Exception ex) {
            d = new Date();
        }
        return d;
    }

    public String getDateStr() {
        String d;
        SimpleDateFormat sdf_ = new SimpleDateFormat("dd.MM.yyyy");
        sdf_.setTimeZone(SimpleTimeZone.getDefault());
        try {
            d = sdf_.format(this.getDate());
        }
        catch (Exception ex) {
            d = sdf_.format(new Date());
        }
        return d;
    }

    public String getTimeStr() {
        String d;
        SimpleDateFormat sdf_ = new SimpleDateFormat("HH:mm:ss");
        sdf_.setTimeZone(SimpleTimeZone.getDefault());
        try {
            d = sdf_.format(this.getDate());
        }
        catch (Exception ex) {
            d = sdf_.format(new Date());
        }
        return d;
    }

    @Override
    public int compareTo(DatenFilmlisteUrl arg0) {
        int ret = 0;
        try {
            String ich = this.arr[2] + " " + this.arr[3];
            String du = arg0.arr[2] + " " + arg0.arr[3];
            if (ich.equals(du)) {
                return 0;
            }
            Date d_ich = this.sdf.parse(ich);
            Date d_du = this.sdf.parse(du);
            ret = d_du.compareTo(d_ich);
        }
        catch (ParseException ex) {
            Log.errorLog(936542876, ex);
        }
        return ret;
    }

    public boolean aelterAls(int tage) {
        boolean ret = false;
        try {
            String ich = this.arr[2] + " " + this.arr[3];
            Date d_ich = this.sdf.parse(ich);
            Calendar cal = Calendar.getInstance();
            cal.add(5, -tage);
            ret = d_ich.before(cal.getTime());
        }
        catch (ParseException ex) {
            Log.errorLog(915468973, ex);
        }
        return ret;
    }

    private void makeArr() {
        this.arr = new String[6];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = "";
        }
    }
}

